package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_abstract")
@org.hibernate.annotations.Table(appliesTo = "fin_abstract", comment = "组合设置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinAbstractDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "code", columnDefinition = "varchar(20) comment '编码'")
    private String code;

    @Column(name = "name", columnDefinition = "varchar(32) comment '名称'")
    private String name;

    @Column(name = "event_id", columnDefinition = "bigint(20) comment '事件表单ID'")
    private Long eventId;

    @Column(name = "event_name", columnDefinition = "varchar(32) comment '事件表单名称'")
    private String eventName;

    @Column(name = "status", columnDefinition = "varchar(32) comment '状态（0-草稿，1-启用，2-停用）'")
    private String status;

}
