package com.elitesland.fin.domain.entity.aporder;

import cn.hutool.core.lang.Assert;
import com.elitesland.fin.common.UdcEnum;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.entity.aporder
 * @date 2022/3/16 10:49
 */
@Data
public class ApOrderDtlGroup {

    private Long masId;

    private Long itemId;

    private String itemCode;

    private String itemName;

    private String smallCateCode;

    private String smallCateName;

    private BigDecimal qty;

    private BigDecimal totalAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal taxAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal exclTaxCurAmt;

    private BigDecimal taxCurAmt;

    private Long buId;

    private String buName;

    private String expensesType;

    private String remark;
    
    private BigDecimal invoicePriceVariance;

    /**
     * 校验汇总单必填信息
     */
    public void check(String createMode) {
        if (createMode.equals(UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())) {
            // 商品信息
            Assert.notNull(this.itemId, "itemId is null");
            Assert.notEmpty(this.itemCode, "itemCode is null");
            Assert.notEmpty(this.itemName, "itemName is null");
            // 小类信息
            Assert.notEmpty(this.smallCateCode, "smallCateCode is null");
            Assert.notEmpty(this.smallCateName, "smallCateName is null");
            // 数量
            Assert.notNull(this.qty, "qty is null");
            // 税额
            Assert.notNull(this.taxAmt, "taxAmt is null");
            // 不含税金额
            Assert.notNull(this.exclTaxAmt, "exclTaxAmt is null");
            Assert.notNull(this.exclTaxCurAmt, "exclTaxCurAmt is null");
            // 含税金额
            Assert.notNull(this.totalAmt, "totalAmt is null");
            Assert.notNull(this.totalCurAmt, "totalCurAmt is null");
        }

    }
}
