/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.generateaccountflow;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowQueryParam;
import com.elitesland.fin.application.facade.param.payment.PaymentRuleConfigParam;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.payment.PaymentRuleConfigDomainService;
import com.elitesland.fin.dto.generateaccountflow.GenerateAccountFlowRpcDTO;
import com.elitesland.fin.enums.PaymentRule;
import com.elitesland.fin.param.generateaccountflow.GenerateAccountFlowRpcParam;
import com.elitesland.fin.service.generateaccountflow.GenerateAccountFlowRpcService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/generateAccountFlow"})
public class GenerateAccountFlowRpcServiceImpl
implements GenerateAccountFlowRpcService {
    private static final Logger log = LoggerFactory.getLogger(GenerateAccountFlowRpcServiceImpl.class);
    private final AccountFlowService accountFlowService;
    private final CreditAccountFlowService creditAccountFlowService;
    private final PaymentRuleConfigDomainService paymentRuleConfigDomainService;
    private final AccountService accountService;
    private final CreditAccountService creditAccountService;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<GenerateAccountFlowRpcDTO>> generateAccountFlow(List<GenerateAccountFlowRpcParam> param) {
        log.info("\u5f00\u59cb\u8c03\u7528\u751f\u6210\u8d26\u6237\u6d41\u6c34:{}", (Object)JSON.toJSONString(param));
        this.checkRefundParam(param);
        ArrayList generateAccountFlowRpcDTOList = new ArrayList();
        generateAccountFlowRpcDTOList.addAll(this.buildAccountFlowParam(param).stream().map(item -> {
            String flowNo = this.accountFlowService.generateAccountFlow((AccountFlowParam)((Object)item));
            GenerateAccountFlowRpcDTO generateAccountFlowRpcDTO = new GenerateAccountFlowRpcDTO();
            generateAccountFlowRpcDTO.setAccountType(item.getAccountType());
            generateAccountFlowRpcDTO.setAccountTypeName(item.getAccountTypeName());
            generateAccountFlowRpcDTO.setAccountCode(item.getAccountCode());
            generateAccountFlowRpcDTO.setAccountName(item.getAccountName());
            generateAccountFlowRpcDTO.setTime(LocalDateTime.now());
            generateAccountFlowRpcDTO.setFlowNo(flowNo);
            generateAccountFlowRpcDTO.setAmount(item.getSourceDocAmount());
            generateAccountFlowRpcDTO.setSourceId(item.getSourceId());
            return generateAccountFlowRpcDTO;
        }).collect(Collectors.toList()));
        generateAccountFlowRpcDTOList.addAll(this.buildCreditAccountFlowParam(param).stream().map(item -> {
            String flowNo = this.creditAccountFlowService.generateCreditAccountFlow((CreditAccountFlowParam)((Object)item));
            GenerateAccountFlowRpcDTO generateAccountFlowRpcDTO = new GenerateAccountFlowRpcDTO();
            generateAccountFlowRpcDTO.setAccountType(item.getCreditAccountType());
            generateAccountFlowRpcDTO.setAccountTypeName(item.getCreditAccountTypeName());
            generateAccountFlowRpcDTO.setAccountCode(item.getCreditAccountCode());
            generateAccountFlowRpcDTO.setAccountName(item.getCreditAccountName());
            generateAccountFlowRpcDTO.setTime(LocalDateTime.now());
            generateAccountFlowRpcDTO.setFlowNo(flowNo);
            generateAccountFlowRpcDTO.setAmount(item.getSourceDocAmount());
            generateAccountFlowRpcDTO.setSourceId(item.getSourceId());
            return generateAccountFlowRpcDTO;
        }).collect(Collectors.toList()));
        return ApiResult.ok(generateAccountFlowRpcDTOList);
    }

    void checkRefundParam(List<GenerateAccountFlowRpcParam> param) {
        Assert.notEmpty(param, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        param.stream().forEach(item -> {
            Assert.notEmpty((CharSequence)item.getAccountType(), (String)"\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getAccountName(), (String)"\u8d26\u6237\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isTrue((UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType()) || UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType()) || UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType()) ? 1 : 0) != 0, (String)"\u8d26\u6237\u7c7b\u578b\u9519\u8bef", (Object[])new Object[0]);
        });
    }

    private List<CreditAccountFlowParam> buildCreditAccountFlowParam(List<GenerateAccountFlowRpcParam> param) {
        List<CreditAccountFlowParam> creditAccountFlowParamList = param.stream().filter(item -> UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType())).map(item -> {
            CreditAccountFlowParam creditAccountFlowParam = new CreditAccountFlowParam();
            creditAccountFlowParam.setSourceDoc(item.getDoc());
            creditAccountFlowParam.setSourceDocType(item.getDocType());
            creditAccountFlowParam.setSourceDocStatus(item.getDocStatus());
            creditAccountFlowParam.setSourceDocAmount(item.getDocAmount());
            creditAccountFlowParam.setSourceId(item.getSourceId());
            creditAccountFlowParam.setSourceNo(item.getSourceNo());
            creditAccountFlowParam.setCreditAccountType(item.getAccountType());
            creditAccountFlowParam.setCreditAccountTypeName(item.getAccountTypeName());
            creditAccountFlowParam.setCreditAccountCode(item.getAccountCode());
            creditAccountFlowParam.setCreditAccountName(item.getAccountName());
            creditAccountFlowParam.setWorkflowProcInstId(item.getWorkflowProcInstId());
            creditAccountFlowParam.setRootDocNo(item.getRootDocNo());
            creditAccountFlowParam.setRootDocType(item.getRootDocType());
            creditAccountFlowParam.setRootDocId(item.getRootDocId());
            return creditAccountFlowParam;
        }).collect(Collectors.toList());
        return creditAccountFlowParamList;
    }

    private List<AccountFlowParam> buildAccountFlowParam(List<GenerateAccountFlowRpcParam> param) {
        List<AccountFlowParam> accountFlowParamList = param.stream().filter(item -> UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType()) || UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType())).map(item -> {
            AccountFlowParam accountFlowParam = new AccountFlowParam();
            accountFlowParam.setSourceDoc(item.getDoc());
            accountFlowParam.setSourceDocType(item.getDocType());
            accountFlowParam.setSourceDocStatus(item.getDocStatus());
            accountFlowParam.setSourceDocAmount(item.getDocAmount());
            accountFlowParam.setSourceId(item.getSourceId());
            accountFlowParam.setSourceNo(item.getSourceNo());
            accountFlowParam.setAccountCode(item.getAccountCode());
            accountFlowParam.setAccountType(item.getAccountType());
            accountFlowParam.setAccountTypeName(item.getAccountTypeName());
            accountFlowParam.setAccountName(item.getAccountName());
            accountFlowParam.setWorkflowProcInstId(item.getWorkflowProcInstId());
            accountFlowParam.setIgnore(item.getIgnore());
            accountFlowParam.setRootDocNo(item.getRootDocNo());
            accountFlowParam.setRootDocType(item.getRootDocType());
            accountFlowParam.setRootDocId(item.getRootDocId());
            return accountFlowParam;
        }).collect(Collectors.toList());
        return accountFlowParamList;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<GenerateAccountFlowRpcDTO>> generateFlow(GenerateAccountFlowRpcParam param) {
        log.info("\u5e93\u5b58\u8c03\u62e8\u5355\u751f\u6210\u6d41\u6c34\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)param));
        this.checkRpcParam(param);
        ApiResult apiResult = ApiResult.ok();
        if (StrUtil.equals((CharSequence)param.getDocStatus(), (CharSequence)PaymentRule.STKTRN_TRN_CL.getDocStatus()) && StrUtil.equals((CharSequence)param.getDocType(), (CharSequence)PaymentRule.STKTRN_TRN_CL.getDocType())) {
            apiResult = this.generateReleaseFlow(param);
        } else if (StrUtil.equals((CharSequence)param.getDocStatus(), (CharSequence)PaymentRule.STKTRN_OUT_CF.getDocStatus()) && StrUtil.equals((CharSequence)param.getDocType(), (CharSequence)PaymentRule.STKTRN_OUT_CF.getDocType())) {
            if (!StrUtil.equals((CharSequence)"NO_RELEASE", (CharSequence)param.getScene())) {
                apiResult = this.generateReleaseFlow(param);
            }
            PaymentRuleConfigParam paymentRuleConfigParam = this.buildPaymentRuleConfigParam(param);
            if (apiResult.isSuccess()) {
                List<PaymentRuleConfigDtlDTO> paymentResult = this.paymentRuleConfigDomainService.pay(paymentRuleConfigParam);
                ArrayList<GenerateAccountFlowRpcDTO> data = (ArrayList<GenerateAccountFlowRpcDTO>)apiResult.getData();
                if (CollectionUtil.isEmpty((Collection)data)) {
                    data = new ArrayList<GenerateAccountFlowRpcDTO>();
                }
                this.buildFlowRpc(paymentResult, data);
                apiResult = ApiResult.ok(data);
            }
        } else if (StrUtil.equals((CharSequence)param.getDocStatus(), (CharSequence)PaymentRule.STKTRN_OUT_CE.getDocStatus()) && StrUtil.equals((CharSequence)param.getDocType(), (CharSequence)PaymentRule.STKTRN_OUT_CE.getDocType())) {
            apiResult = this.generateReleaseFlow(param);
        } else if (StrUtil.equals((CharSequence)param.getDocStatus(), (CharSequence)PaymentRule.STKTRN_IN_CF.getDocStatus()) && StrUtil.equals((CharSequence)param.getDocType(), (CharSequence)PaymentRule.STKTRN_IN_CF.getDocType())) {
            this.buildAccountParam(param);
            apiResult = this.generateAccountFlow(List.of(param));
        } else if (StrUtil.equals((CharSequence)param.getDocStatus(), (CharSequence)PaymentRule.STKTRN_TRN_APPED.getDocStatus()) && StrUtil.equals((CharSequence)param.getDocType(), (CharSequence)PaymentRule.STKTRN_TRN_APPED.getDocType())) {
            PaymentRuleConfigParam paymentRuleConfigParam = this.buildPaymentRuleConfigParam(param);
            List<PaymentRuleConfigDtlDTO> pay = this.paymentRuleConfigDomainService.pay(paymentRuleConfigParam);
            ArrayList<GenerateAccountFlowRpcDTO> collect = new ArrayList<GenerateAccountFlowRpcDTO>();
            this.buildFlowRpc(pay, collect);
            apiResult = ApiResult.ok(collect);
        }
        return apiResult;
    }

    private void checkRpcParam(GenerateAccountFlowRpcParam param) {
        Assert.notBlank((CharSequence)param.getObjectCode(), (String)"\u5bf9\u8c61\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getOuCode(), (String)"\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AccountParam accountParam = new AccountParam();
        accountParam.setSecOuCode(param.getOuCode());
        accountParam.setAccountHolderCode(param.getObjectCode());
        accountParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<AccountDTO> accountDTOList = this.accountService.getAccountByAccountParam(accountParam);
        CreditAccountParam creditAccountParam = new CreditAccountParam();
        creditAccountParam.setObjectCode(param.getObjectCode());
        creditAccountParam.setOuCode(param.getObjectCode());
        creditAccountParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<CreditAccountDTO> creditAccountDTOList = this.creditAccountService.getAccountByAccountParam(creditAccountParam);
        Assert.isTrue((CollectionUtil.isNotEmpty(accountDTOList) || CollectionUtil.isNotEmpty(creditAccountDTOList) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f", (Object[])new Object[0]);
    }

    private void buildFlowRpc(List<PaymentRuleConfigDtlDTO> pay, List<GenerateAccountFlowRpcDTO> collect) {
        pay.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getFlowNo())).forEach(item -> {
            GenerateAccountFlowRpcDTO flowRpcDTO = new GenerateAccountFlowRpcDTO();
            flowRpcDTO.setFlowNo(item.getFlowNo());
            flowRpcDTO.setAccountCode(item.getAccountCode());
            flowRpcDTO.setAmount(item.getPaymentAmount());
            flowRpcDTO.setAccountName(item.getAccountName());
            flowRpcDTO.setAccountType(item.getAccountType());
            flowRpcDTO.setAccountTypeName(item.getAccountTypeName());
            collect.add(flowRpcDTO);
        });
    }

    private void buildAccountParam(GenerateAccountFlowRpcParam param) {
        AccountParam accountParam = new AccountParam();
        accountParam.setSecOuCode(param.getOuCode());
        accountParam.setAccountHolderCode(param.getObjectCode());
        accountParam.setAccountType(UdcEnum.ACCOUNT_TYPE_STORE.getValueCode());
        List<AccountDTO> accountDTOList = this.accountService.getAccountByAccountParam(accountParam);
        Assert.notEmpty(accountDTOList, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u50a8\u503c\u8d26\u6237", (Object[])new Object[0]);
        AccountDTO accountDTO = accountDTOList.get(0);
        param.setAccountCode(accountDTO.getAccountCode());
        param.setAccountName(accountDTO.getAccountName());
        param.setAccountType(accountDTO.getAccountType());
        param.setAccountTypeName(accountDTO.getAccountTypeName());
    }

    private PaymentRuleConfigParam buildPaymentRuleConfigParam(GenerateAccountFlowRpcParam param) {
        PaymentRuleConfigParam paymentRuleConfigParam = new PaymentRuleConfigParam();
        paymentRuleConfigParam.setPaymentRuleConfigDtlIds(this.buildRpcParam(param));
        paymentRuleConfigParam.setDocAmount(param.getDocAmount());
        paymentRuleConfigParam.setOuCode(param.getOuCode());
        paymentRuleConfigParam.setObjectCode(param.getObjectCode());
        paymentRuleConfigParam.setSourceId(param.getSourceId());
        paymentRuleConfigParam.setSourceNo(param.getSourceNo());
        paymentRuleConfigParam.setDoc(param.getDoc());
        paymentRuleConfigParam.setDocType(param.getDocType());
        paymentRuleConfigParam.setDocStatus(param.getDocStatus());
        paymentRuleConfigParam.setWorkflowProcInstId(param.getWorkflowProcInstId());
        paymentRuleConfigParam.setRootDocId(param.getRootDocId());
        paymentRuleConfigParam.setRootDocType(param.getRootDocType());
        paymentRuleConfigParam.setRootDocNo(param.getRootDocNo());
        return paymentRuleConfigParam;
    }

    private Set<Long> buildRpcParam(GenerateAccountFlowRpcParam param) {
        PaymentRuleConfigParam paymentRuleConfigParam = new PaymentRuleConfigParam();
        paymentRuleConfigParam.setDoc(param.getDoc());
        paymentRuleConfigParam.setDocType(param.getDoc().concat("_").concat(param.getDocType()));
        paymentRuleConfigParam.setDocStatus(param.getDoc().concat("_").concat(param.getDocStatus()));
        List<PaymentRuleConfigDtlDTO> configDtlDTOS = this.paymentRuleConfigDomainService.queryPaymentRuleConfigDtl(paymentRuleConfigParam);
        Set<Long> paymentRuleConfigDtlIds = configDtlDTOS.stream().map(BaseModelDTO::getId).collect(Collectors.toSet());
        return paymentRuleConfigDtlIds;
    }

    private ApiResult<List<GenerateAccountFlowRpcDTO>> generateReleaseFlow(GenerateAccountFlowRpcParam param) {
        AccountFlowQueryParam accountFlowParam = new AccountFlowQueryParam();
        accountFlowParam.setSourceId(param.getSourceId());
        accountFlowParam.setSourceNo(param.getSourceNo());
        List<AccountFlowVO> accountFlowVOS = this.accountFlowService.queryByAccountFlowQueryParam(accountFlowParam);
        CreditAccountFlowParam creditAccountFlowParam = new CreditAccountFlowParam();
        creditAccountFlowParam.setSourceId(param.getSourceId());
        creditAccountFlowParam.setSourceNo(param.getSourceNo());
        List<CreditAccountFlowVO> creditAccountFlowVOS = this.creditAccountFlowService.selectListByQueryParam(creditAccountFlowParam);
        if (CollectionUtil.isEmpty(accountFlowVOS) && CollectionUtil.isEmpty(creditAccountFlowVOS)) {
            throw new BusinessException("\u6ca1\u6709\u67e5\u8be2\u5230\u6765\u6e90\u5355\u636e\u3010" + param.getSourceNo() + "\u3011\u7684\u6d41\u6c34");
        }
        ArrayList<GenerateAccountFlowRpcParam> rpcParams = new ArrayList<GenerateAccountFlowRpcParam>();
        HashMap<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>();
        amtMap.put(UdcEnum.IO_TYPE_T.getValueCode(), BigDecimal.ZERO);
        amtMap.put(UdcEnum.IO_TYPE_R.getValueCode(), BigDecimal.ZERO);
        amtMap.put(UdcEnum.IO_TYPE_I.getValueCode(), BigDecimal.ZERO);
        amtMap.put(UdcEnum.IO_TYPE_O.getValueCode(), BigDecimal.ZERO);
        if (StrUtil.equals((CharSequence)param.getDocStatus(), (CharSequence)PaymentRule.STKTRN_TRN_CL.getDocStatus()) && StrUtil.equals((CharSequence)param.getDocType(), (CharSequence)PaymentRule.STKTRN_TRN_CL.getDocType()) || StrUtil.equals((CharSequence)param.getDocStatus(), (CharSequence)PaymentRule.STKTRN_OUT_CF.getDocStatus()) && StrUtil.equals((CharSequence)param.getDocType(), (CharSequence)PaymentRule.STKTRN_OUT_CF.getDocType())) {
            creditAccountFlowVOS = creditAccountFlowVOS.stream().filter(item -> StrUtil.equalsAny((CharSequence)item.getTransactionType(), (CharSequence[])new CharSequence[]{UdcEnum.IO_TYPE_T.getValueCode(), UdcEnum.IO_TYPE_R.getValueCode()})).collect(Collectors.toList());
            accountFlowVOS = accountFlowVOS.stream().filter(item -> StrUtil.equalsAny((CharSequence)item.getTransactionType(), (CharSequence[])new CharSequence[]{UdcEnum.IO_TYPE_T.getValueCode(), UdcEnum.IO_TYPE_R.getValueCode()})).collect(Collectors.toList());
        }
        if (StrUtil.equals((CharSequence)param.getDocStatus(), (CharSequence)PaymentRule.STKTRN_OUT_CE.getDocStatus()) && StrUtil.equals((CharSequence)param.getDocType(), (CharSequence)PaymentRule.STKTRN_OUT_CE.getDocType())) {
            creditAccountFlowVOS = creditAccountFlowVOS.stream().filter(item -> StrUtil.equalsAny((CharSequence)item.getTransactionType(), (CharSequence[])new CharSequence[]{UdcEnum.IO_TYPE_I.getValueCode(), UdcEnum.IO_TYPE_O.getValueCode()})).collect(Collectors.toList());
            accountFlowVOS = accountFlowVOS.stream().filter(item -> StrUtil.equalsAny((CharSequence)item.getTransactionType(), (CharSequence[])new CharSequence[]{UdcEnum.IO_TYPE_I.getValueCode(), UdcEnum.IO_TYPE_O.getValueCode()})).collect(Collectors.toList());
        }
        this.buildAccountFlowParam(param, accountFlowVOS, rpcParams, amtMap);
        this.buildCreditAccountFlowParam(param, creditAccountFlowVOS, rpcParams, amtMap);
        BigDecimal releaseAmt = ((BigDecimal)amtMap.get(UdcEnum.IO_TYPE_T.getValueCode())).subtract((BigDecimal)amtMap.get(UdcEnum.IO_TYPE_R.getValueCode()));
        if (StrUtil.equals((CharSequence)param.getDocStatus(), (CharSequence)PaymentRule.STKTRN_TRN_CL.getDocStatus()) && StrUtil.equals((CharSequence)param.getDocType(), (CharSequence)PaymentRule.STKTRN_TRN_CL.getDocType())) {
            Assert.isTrue((boolean)ObjectUtil.equals((Object)param.getDocAmount(), (Object)releaseAmt), (String)"\u5355\u636e\u3010{}\u3011\u91ca\u653e\u91d1\u989d{}\u4e0e\u5e93\u5b58\u63d0\u4f9b\u91d1\u989d{}\u4e0d\u4e00\u81f4", (Object[])new Object[]{param.getSourceNo(), releaseAmt, param.getDocAmount()});
        }
        log.info("\u5e93\u5b58\u8c03\u62e8\u5355\u7ec4\u88c5\u4e4b\u540e\u8c03\u7528\u751f\u6210\u6d41\u6c34\u53c2\u6570{}", (Object)JSON.toJSONString(rpcParams));
        return this.generateAccountFlow(rpcParams);
    }

    private void buildAccountFlowParam(GenerateAccountFlowRpcParam param, List<AccountFlowVO> accountFlowVOS, List<GenerateAccountFlowRpcParam> rpcParams, Map<String, BigDecimal> amtMap) {
        if (CollectionUtil.isEmpty(accountFlowVOS)) {
            return;
        }
        Map<String, List<AccountFlowVO>> accountTypeMap = accountFlowVOS.stream().collect(Collectors.groupingBy(AccountFlowVO::getAccountType));
        Set<Map.Entry<String, List<AccountFlowVO>>> entries = accountTypeMap.entrySet();
        for (Map.Entry<String, List<AccountFlowVO>> entry : entries) {
            String key = entry.getKey();
            List<AccountFlowVO> value = entry.getValue();
            GenerateAccountFlowRpcParam rpcParam = new GenerateAccountFlowRpcParam();
            this.buildParam(param, rpcParam);
            AccountFlowVO accountFlowVO = value.get(0);
            rpcParam.setAccountCode(accountFlowVO.getAccountCode());
            rpcParam.setAccountType(accountFlowVO.getAccountType());
            rpcParam.setAccountName(accountFlowVO.getAccountName());
            BigDecimal newAmount = BigDecimal.ZERO;
            for (AccountFlowVO item : value) {
                newAmount = this.computeAmt(amtMap, newAmount, item.getAmount(), item.getTransactionType());
            }
            rpcParam.setDocAmount(newAmount);
            rpcParams.add(rpcParam);
        }
    }

    private void buildParam(GenerateAccountFlowRpcParam param, GenerateAccountFlowRpcParam rpcParam) {
        rpcParam.setSourceNo(param.getSourceNo());
        rpcParam.setSourceId(param.getSourceId());
        rpcParam.setDoc(param.getDoc());
        rpcParam.setDocType(param.getDocType());
        rpcParam.setDocStatus(param.getDocStatus());
        if (StrUtil.equals((CharSequence)param.getDocStatus(), (CharSequence)PaymentRule.STKTRN_OUT_CF.getDocStatus()) && StrUtil.equals((CharSequence)param.getDocType(), (CharSequence)PaymentRule.STKTRN_OUT_CF.getDocType())) {
            rpcParam.setDocStatus(PaymentRule.STKTRN_TRN_CF.getDocStatus());
            rpcParam.setDocType(PaymentRule.STKTRN_TRN_CF.getDocType());
        }
        rpcParam.setSourceId(param.getSourceId());
        rpcParam.setSourceNo(param.getSourceNo());
        rpcParam.setRootDocNo(param.getRootDocNo());
        rpcParam.setRootDocId(param.getRootDocId());
        rpcParam.setRootDocType(param.getRootDocType());
        rpcParam.setWorkflowProcInstId(param.getWorkflowProcInstId());
        rpcParam.setRootDocNo(param.getRootDocNo());
        rpcParam.setRootDocType(param.getRootDocType());
        rpcParam.setRootDocId(param.getRootDocId());
    }

    private void buildCreditAccountFlowParam(GenerateAccountFlowRpcParam param, List<CreditAccountFlowVO> creditAccountFlowVOS, List<GenerateAccountFlowRpcParam> rpcParams, Map<String, BigDecimal> amtMap) {
        if (CollectionUtil.isEmpty(creditAccountFlowVOS)) {
            return;
        }
        CreditAccountFlowVO creditAccountFlowVO = creditAccountFlowVOS.get(0);
        GenerateAccountFlowRpcParam rpcParam = new GenerateAccountFlowRpcParam();
        this.buildParam(param, rpcParam);
        rpcParam.setAccountCode(creditAccountFlowVO.getCreditAccountCode());
        rpcParam.setAccountType(creditAccountFlowVO.getCreditAccountType());
        rpcParam.setAccountName(creditAccountFlowVO.getCreditAccountName());
        rpcParam.setWorkflowProcInstId(param.getWorkflowProcInstId());
        BigDecimal newAmount = BigDecimal.ZERO;
        for (CreditAccountFlowVO item : creditAccountFlowVOS) {
            newAmount = this.computeAmt(amtMap, newAmount, item.getAmount(), item.getTransactionType());
        }
        rpcParam.setDocAmount(newAmount);
        rpcParams.add(rpcParam);
    }

    private BigDecimal computeAmt(Map<String, BigDecimal> amtMap, BigDecimal newAmount, BigDecimal oldAmount, String transactionType) {
        amtMap.put(transactionType, amtMap.get(transactionType).add(oldAmount));
        if (UdcEnum.IO_TYPE_T.getValueCode().equals(transactionType) || UdcEnum.IO_TYPE_O.getValueCode().equals(transactionType)) {
            newAmount = newAmount.add(oldAmount);
        }
        if (UdcEnum.IO_TYPE_R.getValueCode().equals(transactionType) || UdcEnum.IO_TYPE_I.getValueCode().equals(transactionType)) {
            newAmount = newAmount.subtract(oldAmount);
        }
        return newAmount;
    }

    public GenerateAccountFlowRpcServiceImpl(AccountFlowService accountFlowService, CreditAccountFlowService creditAccountFlowService, PaymentRuleConfigDomainService paymentRuleConfigDomainService, AccountService accountService, CreditAccountService creditAccountService) {
        this.accountFlowService = accountFlowService;
        this.creditAccountFlowService = creditAccountFlowService;
        this.paymentRuleConfigDomainService = paymentRuleConfigDomainService;
        this.accountService = accountService;
        this.creditAccountService = creditAccountService;
    }
}

