package com.elitesland.fin.application.facade.excel.convert;

import com.elitesland.fin.utils.excel.convert.Converter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
/**
 * LocalDateTime => yyyy-MM-dd HH:mm:ss(String)
 */
public class DefaultDateTimeConverter extends Converter<LocalDateTime, String, Void> {
    private final static DateTimeFormatter yyyyMMdd = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Override
    public String convert(LocalDateTime value) {
        return format(value);
    }
    
    private String format(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return value.format(yyyyMMdd);
    }
}
