package com.elitesland.fin.application.facade.param.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "组合设置")
public class FinAbstractParam extends BaseModelParam {

    @ApiModelProperty("ID列表")
    private List<Long> idList;

    @ApiModelProperty("编码")
    private String code;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("事件表单ID")
    private Long eventId;

    @ApiModelProperty("事件表单名称")
    private String eventName;

    @ApiModelProperty("状态（0-草稿，1-启用，2-停用）")
    private String status;

    @ApiModelProperty("编码、名称")
    private String codeName;

    @ApiModelProperty("明细")
    private List<FinAbstractDetailParam> detailList;

}
