package com.elitesland.fin.domain.service.payorder;

import cn.hutool.json.JSONUtil;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtlDO;
import com.elitesland.fin.domain.param.payorder.PayOrderDtlPageParam;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepo;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.utils.BigDecimalUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:54
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PayOrderDtlDomainServiceImpl implements PayOrderDtlDomainService {

    private final PayOrderDtlRepoProc payOrderDtlRepoProc;

    private final PayOrderDtlRepo payOrderDtlRepo;


    @Override
    public PagingVO<PayOrderDtlDTO> page(PayOrderDtlPageParam param) {
        return payOrderDtlRepoProc.page(param);
    }

    @Override
    public List<PayOrderDtlDTO> queryById(List<Long> ids) {
        return  payOrderDtlRepoProc.queryById(ids);
    }

    @Override
    public List<PayOrderDtlDTO> queryBySourceIdList(List<Long> sourceIdList) {
        return payOrderDtlRepoProc.queryBySourceIdList(sourceIdList);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void updateVerAmt(Map<Long, BigDecimal> payDIdVerAmtMap, List<Long> payDIds) {
        List<PayOrderDtlDO> allByIdsIn = payOrderDtlRepoProc.findAllByIdsIn(payDIds);
        allByIdsIn.forEach(
                k -> {
                    Long orderDtlId = k.getId();
                    if (payDIdVerAmtMap.containsKey(orderDtlId)) {
                        BigDecimal thisAmt = payDIdVerAmtMap.get(orderDtlId);
                        k.setApplyVerAmTing(BigDecimalUtil.getUnify(k.getApplyVerAmTing()).add(BigDecimalUtil.getUnify(thisAmt)));
                        k.setUnVerAmt(BigDecimalUtil.getUnify(k.getTotalAmt()).subtract(BigDecimalUtil.getUnify(k.getVerAmt())).subtract(BigDecimalUtil.getUnify(k.getApplyVerAmTing())));
                    }
                }
        );
        payOrderDtlRepo.saveAll(allByIdsIn);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void resortVerAmt(Map<Long, BigDecimal> payDIdVerAmtMap, List<Long> payDIds) {
        List<PayOrderDtlDO> allByIdsIn = payOrderDtlRepoProc.findAllByIdsIn(payDIds);
        log.info("待回写数据1:{}", JSONUtil.toJsonStr(allByIdsIn));
        allByIdsIn.forEach(
                k -> {
                    Long orderDtlId = k.getId();
                    if (payDIdVerAmtMap.containsKey(orderDtlId)) {
                        BigDecimal thisAmt = payDIdVerAmtMap.get(orderDtlId);
                        k.setApplyVerAmTing(BigDecimalUtil.getUnify(k.getApplyVerAmTing()).subtract(BigDecimalUtil.getUnify(thisAmt)));
                        k.setUnVerAmt(BigDecimalUtil.getUnify(k.getTotalAmt()).subtract(BigDecimalUtil.getUnify(k.getVerAmt())).subtract(BigDecimalUtil.getUnify(k.getApplyVerAmTing())));
                    }
                }
        );
        log.info("待回写数据2:{}", JSONUtil.toJsonStr(allByIdsIn));
        payOrderDtlRepo.saveAll(allByIdsIn);
    }

    @Override
    public List<PayOrderDtlDTO> queryByMasId(Collection<Long> masIds) {
        return payOrderDtlRepoProc.queryByMasId(masIds);
    }

}
