package com.elitesland.fin.infr.dto.payorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:49
 */
@Data
public class PayOrderDTO implements Serializable {

    @ApiModelProperty(value = "内外部客户")
    private String inOutCust;

    private static final long serialVersionUID = -1123102269530735364L;
    private Long id;

    private String sourceNo;

    private Long suppId;

    private String suppCode;

    private String suppName;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private Long apTypeId;

    private String apTypeName;

    private String apTypeCode;

    private Long payTypeId;

    private String payTypeCode;

    private String payTypeName;

    private String payOrderNo;

    private String currCode;

    private String currName;

    private String operator;

    private Long operUserId;

    private String buType;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private LocalDateTime buDate;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private String orderState;

    private BigDecimal exchangeRate;

    private Boolean initFlag;

    private BigDecimal realPayAmt;

    private BigDecimal realPayCurAmt;

    private LocalDateTime apDate;

    private Boolean apFlag;

    private String creator;

    private LocalDateTime createTime;

    private String updater;

    private LocalDateTime modifyTime;

    private String remark;

    private String auditRejection;

    private String createMode;

    private String localCurrCode;

    private String localCurrName;

    private String verState;

    private BigDecimal verAmt;

    private Integer auditDataVersion;

    private String procInstId;

    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private String addrNo;

    private String suppAddrNo;


    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    @ApiModelProperty("拟定状态")
    private String proposedStatus;


    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;
    private String relevanceOuName;

    @ApiModelProperty("明细集合")
    private List<PayOrderDtlDTO> payOrderDtlVOList;

    @ApiModelProperty("扩展信息字段")
    private Map<String, String> extensionInfo;

    @ApiModelProperty("传帐状态(yst-fin/AP_TRANSFER_STATUS)")
    @SysCode(sys = "yst-fin", mod = "AP_TRANSFER_STATUS")
    private String transferStatus;
    private String transferStatusName;

    @ApiModelProperty("付款公司编码")
    private String payOuCode;

    @ApiModelProperty("付款公司ID")
    private Long payOuId;

    @ApiModelProperty("付款公司名称")
    private String payOuName;

    @ApiModelProperty("付款公司是否一致")
    private Boolean payOuSameFlag;

    @ApiModelProperty("制单状态")
    @SysCode(sys = "yst-fin", mod = "PAY_ORDER_SYNC_STATUS")
    private String syncStatus;
    private String syncStatusName;

    @ApiModelProperty("支付状态")
    @SysCode(sys = "yst-fin", mod = "PAY_ORDER_SYNC_STATUS")
    private String payStatus;
    private String payStatusName;

    @ApiModelProperty("失败原因")
    private String syncError;

    @ApiModelProperty("外部系统ID")
    private String outSysKey;

    @ApiModelProperty("交易流水号")
    private String transNo;

    @ApiModelProperty("受理流水号")
    private String rcvSeqNo;

    @ApiModelProperty("系统财务流水号")
    private String sysAcntgSeqNo;

}
