package com.elitesland.fin.application.facade.param.recorder;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/15 13:32
 */
@Data
public class RecOrderSaveParam extends CustomFieldBaseModelVo implements Serializable {


    private static final long serialVersionUID = -8289314318384793466L;

    @ApiModelProperty(value = "内外部客户")
    private String inOutCust;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("销售公司ID")
    private Long ouId;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @ApiModelProperty("应收单类型定义ID")
    private Long arTypeId;

    @ApiModelProperty("应收单类型名称")
    private String arTypeName;

    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;

    @ApiModelProperty("收款单类型ID")
    private Long recTypeId;

    @ApiModelProperty("收款单类型代码")
    private String recTypeCode;

    @ApiModelProperty("收款单类型名称")
    private String recTypeName;

    @ApiModelProperty("收款单号")
    private String recOrderNo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("实际收款金额")
    private BigDecimal realRecAmt;

    @ApiModelProperty("实际收款金额(本位币)")
    private BigDecimal realRecCurAmt;

    @ApiModelProperty("收款日期")
    private LocalDateTime reDate;

    @ApiModelProperty("是否预收")
    private Boolean reFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("单据来源")
    private String createMode;

    @ApiModelProperty("核销状态")
    private String verState;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("销售部门ID")
    private Long buId;

    @ApiModelProperty("销售部门编码")
    private String buCode;

    @ApiModelProperty("销售部门名称")
    private String buName;

    @ApiModelProperty("收款公司编码")
    private String recOuCode;

    @ApiModelProperty("收款公司ID")
    private Long recOuId;

    @ApiModelProperty("收款公司名称")
    private String recOuName;

    @ApiModelProperty("销售组织编码")
    private String orgCode;

    @ApiModelProperty("销售组织ID")
    private Long orgId;

    @ApiModelProperty("销售组织名称")
    private String orgName;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("单据类型")
    private String recOrderType;

    @ApiModelProperty("销售业务员ID")
    private Long saleUserId;

    @ApiModelProperty("销售业务员")
    private String saleUser;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建人ID")
    private Long createUserId;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("明细信息")
    private List<RecOrderDtlSaveParam> orderDtlSaveParamList;

    @ApiModelProperty("地址号")
    private String addrNo;

    @ApiModelProperty("供应商地址号")
    private String suppAddrNo;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    @ApiModelProperty("是否检验")
    private Boolean check = Boolean.TRUE;

    @ApiModelProperty("拟定状态")
    private String proposedStatus;

    @ApiModelProperty("客户类型")
    private String custType2;

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @ApiModelProperty("传帐状态(yst-fin/AP_TRANSFER_STATUS)")
    @SysCode(sys = "yst-fin", mod = "AP_TRANSFER_STATUS")
    private String transferStatus;
    private String transferStatusName;
}
