package com.elitesland.fin.application.facade.vo.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "会计引擎明细")
public class FinAccountEngineDetailsVO extends BaseModelVO {

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("序列号")
    private Integer serialNum;

    @ApiModelProperty("会计引擎名称")
    private String accountEngine;

    @ApiModelProperty("是否启用")
    private Boolean activeFlag;

    @ApiModelProperty("会计引擎条件")
    private List<FinAccEngDetConditionVO> finAccEngDetConditionDetailList;

    @ApiModelProperty("数据行详情")
    private List<FinAccEngDetDataVO> finAccEngDetDataDetailList;

    @SysCode(sys = "yst-fin", mod = "PROPOSED_TYPE")
    @ApiModelProperty("拟定类型")
    private String proposedType;
    private String proposedTypeName;

    @SysCode(sys = "yst-fin", mod = "PROPOSED_TYPE")
    @ApiModelProperty("传帐类型")
    private String transferType;
    private String transferTypeName;
}
