package com.elitesland.fin.application.facade.vo.payorder;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.BigDecimalPruneZeroConverter;
import com.elitesland.fin.application.facade.excel.convert.DateTimeToDateConverter;
import com.elitesland.fin.application.facade.vo.arorder.WriteoffVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/16 10:36
 */
@Data
public class PayOrderVO extends CustomFieldBaseModelVo implements Serializable, WriteoffVO {
    private static final long serialVersionUID = -3556084242260987258L;

    @ApiModelProperty(value = "内外部客户")
    @SysCode(sys = "yst-purc", mod = "IO_TYPE")
    private String inOutCust;
    private String inOutCustName;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;
    @ApiModelProperty("关联公司名称")
    private String relevanceOuName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("来源系统单号")
    private String sourceNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("应付单类型定义ID")
    private Long apTypeId;

    @ApiModelProperty("应付单类型名称")
    private String apTypeName;

    @ApiModelProperty("应付单类型代码")
    private String apTypeCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("付款单类型ID")
    private Long payTypeId;

    @ApiModelProperty("付款单类型代码")
    private String payTypeCode;

    @ApiModelProperty("付款单类型名称")
    private String payTypeName;

    @ApiModelProperty("付款单号")
    private String payOrderNo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("经办人")
    private String operator;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("经办人ID")
    private Long operUserId;

    @ApiModelProperty("业务类型")
    private String buType;
    private String buTypeName;

    @ApiModelProperty("含税总金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalCurAmt;

    @ApiModelProperty("业务日期")
    //@JsonSerialize(using = DateTimeToDateConverter.class)
    private LocalDateTime buDate;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-supp", mod = "APPLY_STATUS")
    private String orderState;
    private String orderStateName;

    @ApiModelProperty("汇率")
    @JsonSerialize(using = BigDecimalPruneZeroConverter.class)
    private BigDecimal exchangeRate;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("实际支付金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal realPayAmt;

    @ApiModelProperty("实际支付金额(本位币)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal realPayCurAmt;

    @ApiModelProperty("预计付款日期")

    private LocalDateTime apDate;

    @ApiModelProperty("是否预付")
    private Boolean apFlag;

    @ApiModelProperty("创建人名称")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("修改人名称")
    private String updater;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("审核拒绝原因")
    private String auditRejection;

    @ApiModelProperty("来源单据")
    @SysCode(sys = "yst-fin", mod = "PAY_DOC_CLS")
    private String createMode;
    private String createModeName;

    @ApiModelProperty("本位币名称")
    private String localCurrCode;

    @ApiModelProperty("本位币编码")
    private String localCurrName;

    @ApiModelProperty("核销状态")
    @SysCode(sys = "yst-fin", mod = "VERIFY_STATUS")
    private String verState;
    private String verStateName;

    @ApiModelProperty("核销金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal verAmt;

    @ApiModelProperty("剩余未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("明细集合")
    private List<PayOrderDtlVO> payOrderDtlVOList;

    @ApiModelProperty("地址号")
    private String addrNo;

    @ApiModelProperty("供应商地址号")
    private String suppAddrNo;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    @SysCode(sys = "yst-fin", mod = "DOC_PROPOSED_STATUS")
    @ApiModelProperty("拟定状态")
    private String proposedStatus;
    private String proposedStatusName;
    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty("传帐状态(yst-fin/AP_TRANSFER_STATUS)")
    @SysCode(sys = "yst-fin", mod = "AP_TRANSFER_STATUS")
    private String transferStatus;
    private String transferStatusName;

    @ApiModelProperty("付款公司编码")
    private String payOuCode;

    @ApiModelProperty("付款公司ID")
    private Long payOuId;

    @ApiModelProperty("付款公司名称")
    private String payOuName;

    @ApiModelProperty("付款公司是否一致")
    private Boolean payOuSameFlag;

    @ApiModelProperty("制单状态")
    @SysCode(sys = "yst-fin", mod = "PAY_ORDER_SYNC_STATUS")
    private String syncStatus;
    private String syncStatusName;

    @ApiModelProperty("支付状态")
    @SysCode(sys = "yst-fin", mod = "PAY_ORDER_SYNC_STATUS")
    private String payStatus;
    private String payStatusName;

    @ApiModelProperty("失败原因")
    private String syncError;

    @ApiModelProperty("外部系统ID")
    private String outSysKey;

    @ApiModelProperty("交易流水号")
    private String transNo;

    @ApiModelProperty("受理流水号")
    private String rcvSeqNo;

    @ApiModelProperty("系统财务流水号")
    private String sysAcntgSeqNo;
}
