package com.elitesland.fin.application.service.aporder;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlConvert;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderDtlVO;
import com.elitesland.fin.domain.param.aporder.ApOrderDtlPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDtlDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.provider.InvWhProvider;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.aporder
 * @date 2022/3/17 13:16
 */
@Service
@RequiredArgsConstructor
public class ApOrderDtlServiceImpl implements ApOrderDtlService {

    private final ApOrderDtlDomainService apOrderDtlDomainService;
    private final InvWhProvider invWhProvider;

    @SysCodeProc
    @Override
    public PagingVO<ApOrderDtlVO> page(ApOrderDtlPageParam apOrderDtlPageParam) {
        PagingVO<ApOrderDtlDTO> page = apOrderDtlDomainService.page(apOrderDtlPageParam);
        PagingVO<ApOrderDtlVO> res = ApOrderDtlConvert.INSTANCE.convertPage(page);
        if(CollectionUtils.isNotEmpty(res.getRecords())){
            List<ApOrderDtlVO> records = res.getRecords();
            Map<Long, String> whMap = new HashMap<>();
            List<Long> whIds = records.stream().map(ApOrderDtlVO::getPurRecvWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(whIds)){
                ApiResult<List<InvWhRpcSimpleDTO>> apiResult = invWhProvider.querySimple(whIds);
                if(apiResult.isSuccess() && apiResult.getData() != null){
                    whMap = apiResult.getData().stream().collect(Collectors.toMap(InvWhRpcSimpleDTO::getWhId, InvWhRpcSimpleDTO::getWhName));
                }
            }
            Map<Long, String> finalWhMap = whMap;
            records.forEach(apOrderDtlDTO -> {
                if(apOrderDtlDTO.getPurRecvWhId() != null){
                    apOrderDtlDTO.setPurRecvWhName(finalWhMap.get(apOrderDtlDTO.getPurRecvWhId()));
                }
            });
        }
        return res;
    }
}
