package com.elitesland.fin.application.service.workflow.aporder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.facade.param.arorder.ArOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.vo.artype.ArTypeVO;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.artype.ArTypeService;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.QApOrderDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.pur.RmiPurRpcService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.pur.dto.account.PurAccountCheckQtyDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.pur.provider.PurAccountProvider;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * @author Jason.zhao
 * @date 2022/5/7 10:23
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ApOrderProcessServiceImpl implements ApOrderProcessService {

    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;

    private final FinApPayVerApplyService finApPayVerApplyService;

    private final ApOrderRepoProc apOrderRepoProc;
    private final ApOrderRepo apOrderRepo;

    private final ApOrderDtlRepoProc apOrderDtlRepoProc;

    private final JPAQueryFactory jpaQueryFactory;

    private final PurAccountProvider purAccountProvider;
    private final TaskExecutor taskExecutor;

    private final RmiPurRpcService rmiPurRpcService;
    private final ArOrderRepoProc arOrderRepoProc;
    private final ArOrderRepo arOrderRepo;
    private final ArOrderService arOrderService;
    private final ArTypeService arTypeService;

    private final PurSuppOutService purSuppOutService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;


    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        ApOrderDTO apOrderDTO = apOrderRepoProc.get(id);
        List<ApOrderDtlDTO> apOrderDtlDTOS = apOrderDtlRepoProc.listByMisId(id);
        //ApOrderDO newApOrderDO = apOrderRepo.findById(id).get();
        if (apOrderDTO == null) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }
        //ApOrderDTO apOrderDTO = ApOrderConvert.INSTANCE.doConvertToDto(newApOrderDO);

        QApOrderDO apOrderDO = QApOrderDO.apOrderDO;
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(apOrderDO)
                .set(apOrderDO.procInstStatus, procInstStatus)
                .where(apOrderDO.id.eq(id));

        //单据状态
        switch (procInstStatus) {
            case NOTSUBMIT: // 未提交
                //一般情况将单据状态变成"草稿"
                jpaUpdateClause.set(apOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            case INTERRUPT: // 中断执行
                //一般情况将单据状态变成"草稿",并且将单据上的"流程实例状态"，"流程实例ID"清成null(不是空字符串)
                jpaUpdateClause.set(apOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(apOrderDO.procInstId, (String) null);
                break;
            case REJECTED: // 审批拒绝
                //一般情况将单据状态变成"草稿"或"拒绝"
                jpaUpdateClause.set(apOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(apOrderDO.approvedTime, LocalDateTime.now())
                        .set(apOrderDO.auditDate, LocalDateTime.now())
                        .set(apOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(apOrderDO.auditRejection, commentInfo.getComment())
                        .set(apOrderDO.auditUser, commentInfo.getUserName());
                break;
            case INVALID: // 作废
                //一般情况将单据状态变成"作废" ，或直接删除单据
                jpaUpdateClause.set(apOrderDO.orderState, UdcEnum.APPLY_STATUS_VOID.getValueCode())
                        .set(apOrderDO.auditDate, LocalDateTime.now())
                        .set(apOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(apOrderDO.auditRejection, commentInfo.getComment())
                        .set(apOrderDO.auditUser, commentInfo.getUserName())
                        .set(apOrderDO.procInstId, (String) null);
                break;
            case APPROVING: // 审批中
                //一般情况将单据状态变成"审批中
                jpaUpdateClause.set(apOrderDO.orderState, UdcEnum.APPLY_STATUS_DOING.getValueCode())
                        .set(apOrderDO.submitTime,LocalDateTime.now());
                break;
            case APPROVED: // 最终节点审批通过
                //一般情况将单据状态变成"审批通过"
                jpaUpdateClause.set(apOrderDO.orderState, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode())
                    .set(apOrderDO.proposedStatus, UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode())
                        .set(apOrderDO.approvedTime, LocalDateTime.now())
                        .set(apOrderDO.auditDate, LocalDateTime.now())
                        .set(apOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(apOrderDO.auditUser, commentInfo.getUserName());
                break;
            default:
                break;
        }
        //执行
        jpaUpdateClause.execute();
        //4,其他业务
        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {
            // 回写采购对账单开票数量
            if (UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode().equals(apOrderDTO.getCreateMode())) {
                List<ApOrderDtlDTO> apOrderDtlDTOList = apOrderDtlRepoProc.listByMisId(id);
                if (!CollectionUtils.isEmpty(apOrderDtlDTOList)) {
                    List<PurAccountCheckQtyDTO> purAccountCheckQtyDTOList = apOrderDtlDTOList.stream().map(d -> {
                        PurAccountCheckQtyDTO purAccountCheckQtyDTO = new PurAccountCheckQtyDTO();
                        purAccountCheckQtyDTO.setDocNo(d.getSourceNo());
                        purAccountCheckQtyDTO.setInvoiceQty(d.getQty());
                        purAccountCheckQtyDTO.setLineNo(BigDecimal.valueOf(d.getSourceLine()));
                        return purAccountCheckQtyDTO;
                    }).collect(Collectors.toList());
                    purAccountProvider.addInvoiceQty(purAccountCheckQtyDTOList);
                }
            }

            //获取供应商类型
            ApOrderDTO orderDTO = apOrderRepoProc.get(id);
            String suppType2 = getSuppType2(orderDTO);
            List<ArOrderDO> data = arOrderRepoProc.findBySourceNo(orderDTO.getApOrderNo());
            //应付单的供应商类型=系统内，审批通过后同步生成审批通过的应收单。如果应收单中来源单号已经有此应付单，禁止生成。
            if ("INNER".equals(suppType2) && "MANU".equalsIgnoreCase(orderDTO.getCreateMode())) {
                if (CollUtil.isEmpty(data)) { //没有关联的收款单
                    ArOrderSaveParam arOrderSaveParam = getArOrderSaveParam(apOrderDTO, apOrderDtlDTOS);
                    arOrderService.save(arOrderSaveParam);
                }
            }

            //异步
            CompletableFuture.runAsync(() ->{
                //自动核销
                log.info("应付单审批通过，开始自动核销");
                finApPayVerApplyService.autoWriteoffAp(apOrderDTO);
                //处理核销状态
                updateVerState(id);
            }, taskExecutor);


        }
    }

    private Long getArTypeIdByCode(String code) {
        if (StrUtil.isBlank(code)) {
            return null;
        }
        List<ArTypeVO> arTypeVOS = arTypeService.getList().computeData();
        Optional<ArTypeVO> first = arTypeVOS.stream().filter(e -> e.getArTypeCode().equals(code)).findFirst();
        return first.map(ArTypeVO::getId).orElse(null);
    }

    private ArOrderSaveParam getArOrderSaveParam(ApOrderDTO orderDTO, List<ApOrderDtlDTO> apOrderDtlDTOS) {
        log.info("应付单生成应收单入参:orderDTO:{},apOrderDtlDTOS:{}", JSONUtil.toJsonStr(orderDTO),
                JSONUtil.toJsonStr(apOrderDtlDTOS));
        //获取供应商信息
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setSuppCodes(Arrays.asList(orderDTO.getSuppCode()));
        List<PurSuppBaseRpcDTO> baseSuppByParam = purSuppOutService.findBaseSuppByParam(purSuppBaseRpcParam);
        if (CollUtil.isEmpty(baseSuppByParam)) {
            throw new com.elitescloud.boot.exception.BusinessException("应付单公司供应商信息不存在");
        }
        PurSuppBaseRpcDTO purSuppBaseRpcDTO = baseSuppByParam.get(0);
        log.info("供应商信息:{}", JSONUtil.toJsonStr(purSuppBaseRpcDTO));
        String ouCode2 = purSuppBaseRpcDTO.getOuCode2();
        List<OrgOuRpcSimpleDTO> baseOuByCodes =
                rmiOrgOuRpcServiceService.findBaseOuByCodes(Arrays.asList(ouCode2));
        if (CollUtil.isEmpty(baseOuByCodes)) {
            throw new com.elitescloud.boot.exception.BusinessException("供应商关联的公司信息不存在");
        }
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = baseOuByCodes.get(0);
        log.info("客户关联公司信息:{}", JSONUtil.toJsonStr(orgOuRpcSimpleDTO));

        //获取客户信息
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCorBusinCodes(Arrays.asList(orderDTO.getOuCode()));
        List<CustBaseDTO> baseCustByParam = rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollUtil.isEmpty(baseCustByParam)) {
            throw new com.elitescloud.boot.exception.BusinessException("应付单客户信息不存在");
        }
        CustBaseDTO custBaseDTO = baseCustByParam.get(0);
        log.info("客户信息:{}", JSONUtil.toJsonStr(custBaseDTO));

        ArOrderSaveParam param = new ArOrderSaveParam();
        param.setTaxFlag(true);
        param.setInOutCust(custBaseDTO.getInOutCust());
        //销售公司
        param.setOuCode(orgOuRpcSimpleDTO.getOuCode());
        param.setOuId(orgOuRpcSimpleDTO.getId());
        param.setOuName(orgOuRpcSimpleDTO.getOuName());
        //客户
        param.setCustCode(custBaseDTO.getCustCode());
        param.setCustId(custBaseDTO.getId());
        param.setCustName(custBaseDTO.getCustName());
        //应收单类型
        param.setArTypeCode("YSD01_SYS");
        param.setArTypeName("标准应收单");
        param.setArTypeId(getArTypeIdByCode("YSD01_SYS"));
        //业务日期
        param.setBuDate(orderDTO.getBuDate());
        //币种
        param.setCurrCode(StrUtil.isNotBlank(orderDTO.getCurrCode()) ? orderDTO.getCurrCode() : "CNY");
        param.setCurrName(StrUtil.isNotBlank(orderDTO.getCurrName()) ? orderDTO.getCurrName() : "人民币");
        param.setLocalCurrCode(StrUtil.isNotBlank(orderDTO.getLocalCurrCode()) ? orderDTO.getLocalCurrCode() :
                "CNY");
        param.setLocalCurrName(StrUtil.isNotBlank(orderDTO.getLocalCurrName()) ? orderDTO.getLocalCurrName() :
                "人民币");
        //来源单据
        param.setCreateMode("AP");
        //关联公司
        param.setRelevanceOuCode(orderDTO.getOuCode());
        //收款协议编码->客户上维护的收款协议
        param.setProtocolCode(orderDTO.getProtocolCode());
        //汇率
        param.setExchangeRate(orderDTO.getExchangeRate());
        //含税金额
        param.setTotalAmt(orderDTO.getTotalAmt());
        //含税金额（本位币)
        param.setTotalCurAmt(orderDTO.getTotalCurAmt());
        //不含税金额
        param.setExclTaxAmt(orderDTO.getExclTaxAmt());
        //不含税金额（本位币）
        param.setExclTaxCurAmt(orderDTO.getExclTaxCurAmt());
        //税额
        param.setTaxAmt(orderDTO.getTaxAmt());
        //税额(本位币)
        param.setTaxCurAmt(orderDTO.getTaxCurAmt());
        //是否期初
        param.setInitFlag(orderDTO.getInitFlag());
        //单据状态
        param.setOrderState("COMPLETE");
        //是否红冲
        param.setRedState(orderDTO.getRedState());
        //红冲对应原单号
        String redSourceNo = orderDTO.getRedSourceNo();
        if (StrUtil.isNotBlank(redSourceNo)) {
            List<ArOrderDO> bySourceNo = arOrderRepoProc.findBySourceNo(redSourceNo);
            if (CollUtil.isNotEmpty(bySourceNo)) {
                ArOrderDO arOrderDO = bySourceNo.get(0);
                param.setRedSourceNo(arOrderDO.getArOrderNo());
                param.setRedSourceId(arOrderDO.getId());
                arOrderDO.setRedState(true);
                arOrderRepo.saveAndFlush(arOrderDO);
                // param.setRedState(true);
            }
        }
        //拟定状态
        param.setProposedStatus("DRAFT");
        //来源单号
        param.setSourceNo(orderDTO.getApOrderNo());
        //核销状态
        param.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());

        //明细行
        List<ArOrderDtlSaveParam> orderDtlSaveParamList = apOrderDtlDTOS.stream().map(
                apOrderDtlDTO -> {
                    ArOrderDtlSaveParam dtlSaveParam = new ArOrderDtlSaveParam();
                    dtlSaveParam.setProtocolCode(orderDTO.getProtocolCode());
                    dtlSaveParam.setSourceNo(apOrderDtlDTO.getSourceNo());
                    dtlSaveParam.setSourceLine(apOrderDtlDTO.getSourceLine());
                    dtlSaveParam.setItemId(apOrderDtlDTO.getItemId());
                    dtlSaveParam.setItemCode(apOrderDtlDTO.getItemCode());
                    dtlSaveParam.setItemName(apOrderDtlDTO.getItemName());
                    dtlSaveParam.setItemType(apOrderDtlDTO.getItemType());
                    dtlSaveParam.setSmallCateCode(apOrderDtlDTO.getSmallCateCode());
                    dtlSaveParam.setSmallCateName(apOrderDtlDTO.getSmallCateName());
                    dtlSaveParam.setUom(apOrderDtlDTO.getUom());
                    dtlSaveParam.setUomName(apOrderDtlDTO.getUomName());
                    dtlSaveParam.setQty(apOrderDtlDTO.getQty());
                    dtlSaveParam.setExclTaxPrice(apOrderDtlDTO.getExclTaxPrice());
                    dtlSaveParam.setPrice(apOrderDtlDTO.getPrice());
                    dtlSaveParam.setTaxRate(apOrderDtlDTO.getTaxRate());
                    dtlSaveParam.setTotalAmt(apOrderDtlDTO.getTotalAmt());
                    dtlSaveParam.setTotalCurAmt(apOrderDtlDTO.getTotalCurAmt());
                    dtlSaveParam.setExclTaxAmt(apOrderDtlDTO.getExclTaxAmt());
                    dtlSaveParam.setExclTaxCurAmt(apOrderDtlDTO.getExclTaxCurAmt());
                    dtlSaveParam.setTaxAmt(apOrderDtlDTO.getTaxAmt());
                    dtlSaveParam.setTaxCurAmt(apOrderDtlDTO.getTaxCurAmt());

                    dtlSaveParam.setVerAmt(BigDecimal.ZERO);
                    dtlSaveParam.setUnVerAmt(orderDTO.getTotalAmt());
                    dtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);

                    return dtlSaveParam;
                }
        ).collect(Collectors.toList());
        param.setArOrderDtlParamList(orderDtlSaveParamList);
        log.info("生成应收单参数:{}", JSONUtil.toJsonStr(param));
        return param;
    }


    private String getSuppType2(ApOrderDTO orderDTO) {
        Long suppId = orderDTO.getSuppId();
        List<PurSuppBaseDTO> bySuppIdBatch = rmiPurRpcService.findBySuppIdBatch(Collections.singletonList(suppId));
        if (CollUtil.isEmpty(bySuppIdBatch)) {
            throw new com.elitescloud.boot.exception.BusinessException("单据对应供应商信息不存在");
        }
        PurSuppBaseDTO purSuppBaseDTO = bySuppIdBatch.get(0);
        return purSuppBaseDTO.getSuppType2();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        ApOrderDTO apOrderDTO = apOrderRepoProc.get(businessId);
        //ApOrderDO newApOrderDO = apOrderRepo.findById(businessId).get();

        if (apOrderDTO == null) {
            throw new BusinessException("单据(id:" + businessId + ")不存在,无法审批");
        }
        //ApOrderDTO apOrderDTO = ApOrderConvert.INSTANCE.doConvertToDto(newApOrderDO);

        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder()
                .ouIds(Collections.singletonList(apOrderDTO.getOuId()))
                .flowRoleCodes(Collections.singletonList(customParams))
                .build();
        List<Long> userIdsByFlowRoles = sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> e + "").collect(Collectors.toCollection(ArrayList::new));

    }

    private void updateVerState(Long id){
        //处理核销状态
        ApOrderDTO newApOrderDTO = apOrderRepoProc.get(id);
        List<ApOrderDtlDTO> newApOrderDtlDTOList = apOrderDtlRepoProc.listByMisId(id);
        BigDecimal verAmtSum = BigDecimal.ZERO;//已核销金额
        BigDecimal verAmtingSum = BigDecimal.ZERO;//核销中金额
        BigDecimal unVerAmtSum = BigDecimal.ZERO;//未核销金额
        if (CollUtil.isNotEmpty(newApOrderDtlDTOList)) {
            for (ApOrderDtlDTO apOrderDtlDTO : newApOrderDtlDTOList) {
                if(null != apOrderDtlDTO.getVerAmt()){
                    verAmtSum = verAmtSum.add(apOrderDtlDTO.getVerAmt());
                }
                if(apOrderDtlDTO.getApplyVerAmTing()!=null){
                    verAmtingSum = verAmtingSum.add(apOrderDtlDTO.getApplyVerAmTing());
                }
                if(apOrderDtlDTO.getUnVerAmt()!=null){
                    unVerAmtSum = unVerAmtSum.add(apOrderDtlDTO.getUnVerAmt());
                }
            }
        }

        String verState = null;
        /*if (Objects.nonNull(newApOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newApOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) != 0 &&
                Objects.nonNull(newApOrderDTO.getTotalAmt()) && unVerAmtSum.compareTo(newApOrderDTO.getTotalAmt()) != 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();

        } else if (unVerAmtSum.compareTo(BigDecimal.ZERO) == 0){
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        }*/
        if (unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode();
        } else if (Objects.nonNull(newApOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newApOrderDTO.getTotalAmt()) == 0) {
            verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        } else {
            verState = UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode();
        }

        if (StringUtils.isNotBlank(verState)){
            apOrderRepoProc.updateVerState(verState,id);
        }

    }

}
