package com.elitesland.fin.application.web.account;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.facade.param.account.AccountAppParam;
import com.elitesland.fin.application.facade.vo.account.AccountAmtSumVO;
import com.elitesland.fin.application.facade.vo.account.AccountOuVO;
import com.elitesland.fin.application.facade.vo.account.AccountAmtFlowVO;
import com.elitesland.fin.application.facade.vo.app.StoreAccountCustAppVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.app.AppAccountService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/08/09
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/fin/account/app")
@RequiredArgsConstructor
@Api(value = "账户APP端", tags = {"账户APP端"})
public class AccountAppController {

    private final AccountService accountService;
    private final AppAccountService appAccountService;

    @ApiOperation("根据门店编码查询客户信息")
    @PostMapping("/select/store/cust")
    public ApiResult<StoreAccountCustAppVO> selectCustByStore(@RequestBody AccountAppParam accountAppParam) {
        return ApiResult.ok(appAccountService.selectCustByStore(accountAppParam));
    }

    @ApiOperation("根据客户编码查询账户和信用账户的公司信息")
    @PostMapping("/select/ou")
    public ApiResult<List<AccountOuVO>> selectOuByParam(@RequestBody AccountAppParam accountAppParam) {
        return ApiResult.ok(accountService.selectOuByParam(accountAppParam));
    }

    @ApiOperation("根据客户编码和公司查询账户和信用账户的金额汇总信息")
    @PostMapping("/select/amtSum")
    public ApiResult<AccountAmtSumVO> selectAmtSumByParam(@RequestBody AccountAppParam accountAppParam) {
        return ApiResult.ok(accountService.selectAmtSumByParam(accountAppParam));
    }

    @ApiOperation("根据客户编码、公司和账户类型查询账户和信用账户的金额和流水信息")
    @PostMapping("/select/accountAmtAndFlow")
    public ApiResult<AccountAmtFlowVO> selectAccountAmtAndFlow(@RequestBody AccountAppParam accountAppParam) {
        return ApiResult.ok(accountService.selectAccountAmtAndFlow(accountAppParam));
    }

    @ApiOperation("根据客户编码、公司和账户类型查询账户和信用账户的金额")
    @PostMapping("/select/accountAmt")
    public ApiResult<AccountAmtFlowVO> selectAccountAmt(@RequestBody AccountAppParam accountAppParam) {
        return ApiResult.ok(accountService.selectAccountAmt(accountAppParam));
    }

}
