package com.elitesland.fin.application.web.account;


import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountStorageFollowReq;
import com.elitesland.fin.application.facade.param.account.AccountStorageParam;
import com.elitesland.fin.application.facade.param.account.AccountStorageQueryReq;
import com.elitesland.fin.application.facade.param.account.AccountStorageSaveParam;
import com.elitesland.fin.application.facade.vo.account.AccountStorageVO;
import com.elitesland.fin.application.service.account.AccountStorageService;
import com.elitesland.fin.application.service.unionpay.UnionPayService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.entity.account.AccountStorageDO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author sunxw
 * @description 账户储值api
 * @Date 2023/5/18
 */
@Slf4j
@Api(tags = "账户储值tims")
@RestController
@RequestMapping(value = "/accountStorage", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
@BusinessObject(businessType = FinBusinessObjectConstant.FIN_ADJUST_ORDER_TO, businessDoClass = AccountStorageDO.class)
public class AccountStorageController {

    private final AccountStorageService accountStorageService;
    private final UnionPayService unionPayService;

    @ApiOperation("账户储值分页")
    @PostMapping("/page")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "储值订单分页",
            businessObjectType = FinBusinessObjectConstant.FIN_ADJUST_ORDER_TO,operationCode = FinBusinessObjectConstant.FIN_ADJUST_ORDER_TO_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<AccountStorageVO>> page(@RequestBody AccountStorageParam params){
        log.info("[FIN-ACCOUNT-STORAGE] page  param ={}", params);
        PagingVO<AccountStorageVO> list = accountStorageService.page(params);
        return ApiResult.ok(list);
    }

    @ApiOperation("账户储值列表")
    @PostMapping("/list")
    public ApiResult<List<AccountStorageVO>> list(@RequestBody AccountStorageParam params){
        log.info("[FIN-ACCOUNT-STORAGE] list  param ={}", params);
        List<AccountStorageVO> list = accountStorageService.list(params);
        return ApiResult.ok(list);
    }

    @ApiOperation("储值订单详情")
    @GetMapping("/single/{id}")
    public ApiResult<AccountStorageVO> single(@PathVariable("id") Long id){
        log.info("[FIN-ACCOUNT-STORAGE] list  param ={}", id);
        AccountStorageVO vo = accountStorageService.single(id);
        return ApiResult.ok(vo);
    }

    @ApiOperation("账户储值新增")
    @PostMapping("/save")
    public ApiResult<AccountStorageVO> save(@RequestBody AccountStorageSaveParam saveParams){
        log.info("[FIN-ACCOUNT-STORAGE] save param ={}", saveParams);
        if (ObjectUtils.isEmpty(saveParams.getRemitterAmt())){
            log.warn("账户储值金额有误:{}",saveParams.getRemitterAmt());
            return ApiResult.fail("账户储值金额有误");
        }
        AccountStorageVO vo = accountStorageService.save(saveParams);
        return ApiResult.ok(vo);
    }

    @ApiOperation("交易退款预留接口")
    @PostMapping("/followPay")
    public ApiResult<Void> followPay(@RequestBody AccountStorageFollowReq followReq){
        //接口暂定,具体暴露时再确认字段等
        log.info("[FIN-ACCOUNT-STORAGE] followPay  param ={}", followReq);
        accountStorageService.followPay(followReq);
        return ApiResult.ok();
    }

    @ApiOperation("交易状态查询预留接口")
    @GetMapping("/queryPay")
    public ApiResult<Void> queryPay(AccountStorageQueryReq req){
        //接口暂定,具体暴露时再确认字段等
        log.info("[FIN-ACCOUNT-STORAGE] queryPay  param ={}", req);
        unionPayService.queryPay(req);
        return ApiResult.ok();
    }

}
