package com.elitesland.fin.application.web.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFlexibleVO;
import com.elitesland.fin.application.service.accountingengine.FinFlexibleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * @author gyj
 * @date 2023/10/10
 */
@RestController
@RequestMapping("/fin/flexible")
@RequiredArgsConstructor
@Api(value = "值集", tags = {"值集"})
public class FinFlexibleController {

    private final FinFlexibleService finFlexibleService;

    @PostMapping("/saveOrUpdate")
    @ApiOperation("新增/修改")
    public ApiResult<Long> saveOrUpdate(@RequestBody FinFlexibleParam finFlexibleParam) {

        return ApiResult.ok(finFlexibleService.saveOrUpdate(finFlexibleParam));
    }

    @PostMapping("/page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<FinFlexibleVO>> page(@RequestBody FinFlexibleParam finFlexibleParam) {
        return ApiResult.ok(finFlexibleService.page(finFlexibleParam));
    }

    @PostMapping("enableOrDisable")
    @ApiOperation("启用/禁用")
    public ApiResult<Void> enableOrDisable(@RequestBody FinFlexibleParam finFlexibleParam) {
        finFlexibleService.enableOrDisable(finFlexibleParam);
        return ApiResult.ok();
    }


}
