package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_abstract_detail")
@org.hibernate.annotations.Table(appliesTo = "fin_abstract_detail", comment = "组合设置明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinAbstractDetailDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表ID'")
    private Long masId;

    @Column(name = "line_no", columnDefinition = "int(11) comment '行号'")
    private Integer lineNo;

    @Column(name = "column_code", columnDefinition = "varchar(32) comment '字段'")
    private String columnCode;

    @Column(name = "column_name", columnDefinition = "varchar(32) comment '字段名称'")
    private String columnName;

}
