package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_event_table_line")
@org.hibernate.annotations.Table(appliesTo = "fin_event_table_line", comment = "事件表单明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinEventTableLineDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "table_name", columnDefinition = "varchar(20) comment '表单名称'")
    private String tableName;

    @Column(name = "column_name", columnDefinition = "varchar(32) comment '字段名称'")
    private String columnName;

    @Column(name = "column_type", columnDefinition = "varchar(32) comment '字段类型'")
    private String columnType;

    @Column(name = "column_comment", columnDefinition = "varchar(32) comment '字段含义'")
    private String columnComment;
}
