package com.elitesland.fin.repo.writeoff;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.fin.application.facade.dto.writeoff.ApOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.param.aporder.FinApOrderDetailQuery;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderDtlVO;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.entity.aporder.QApOrderDO;
import com.elitesland.fin.domain.entity.aporder.QApOrderDtlDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * 应收单.
 *
 * @author shihao.ma
 * @since 2023/9/14
 */
@Repository
public class ApOrderDetailRepoProc extends BaseRepoProc<ApOrderDtlDO> {

    private static final QApOrderDO QMas = QApOrderDO.apOrderDO;
    private static final QApOrderDtlDO QDetail = QApOrderDtlDO.apOrderDtlDO;

    protected ApOrderDetailRepoProc() {
        super(QDetail);
    }

    public ApOrderDtlDO getApOrderDetailAmt(Long arDId) {
        JPAQuery<ApOrderDtlDO> select = jpaQueryFactory.select(Projections.fields(ApOrderDtlDO.class,
                        QDetail.id,
                        QDetail.totalAmt,
                        QDetail.verAmt,
                        QDetail.applyVerAmTing,
                        QDetail.unVerAmt,
                        QDetail.auditDataVersion
                ))
                .from(QDetail)
                .where(QDetail.id.eq(arDId));
        return select.fetchOne();
    }

    /**
     * 更新核销金额.
     *
     * @param update 更新结果
     * @return 更新条数
     */
    public long updateVerAmt(ApOrderAmtUpdateDTO update) {
        return jpaQueryFactory.update(QDetail)
                .set(QDetail.verAmt, update.getVerAmt())
                .set(QDetail.applyVerAmTing, update.getVerAmting())
                .set(QDetail.unVerAmt, update.getUnVerAmt())
                .set(QDetail.auditDataVersion, update.getVersion() + 1)
                .where(QDetail.id.eq(update.getApDId()).and(QDetail.auditDataVersion.eq(update.getVersion())))
                .execute();
    }

    /**
     * 查询应收单明细、明细扩展集合.
     *
     * @param query 查询条件
     * @return 查询结果集
     */
    public List<ApOrderDtlVO> listArOrderDetail(FinApOrderDetailQuery query) {

        JPAQuery<ApOrderDtlVO> select = jpaQueryFactory.select(Projections.bean(ApOrderDtlVO.class,
                        QDetail.id,
                        QDetail.masId,
                        QDetail.sourceNo,
                        QDetail.sourceLine,
                        QDetail.itemId,
                        QDetail.itemCode,
                        QDetail.itemName,
                        QDetail.itemType,
                        QDetail.smallCateCode,
                        QDetail.smallCateName,
                        QDetail.uom,
                        QDetail.uomName,
                        QDetail.qty,
                        QDetail.exclTaxPrice,
                        QDetail.price,
                        QDetail.taxRate,
                        QDetail.totalAmt,
                        QDetail.exclTaxAmt,
                        QDetail.taxAmt,
                        QDetail.totalCurAmt,
                        QDetail.exclTaxCurAmt,
                        QDetail.taxCurAmt,
                        QDetail.verAmt,
                        QDetail.applyVerAmTing,
                        QDetail.unVerAmt,
                        QDetail.auditDataVersion
                ))
                .from(QDetail);

        List<Predicate> predicates = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(query.getApDIds())) {
            predicates.add(QDetail.id.in(query.getApDIds()));
        }
        if (CollectionUtils.isNotEmpty(query.getMasIds())) {
            predicates.add(QDetail.masId.in(query.getMasIds()));
        }
        select.where(ExpressionUtils.allOf(predicates));
        return select.fetch();
    }
}
