package com.elitesland.fin.repo.writeoff;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.fin.application.facade.dto.writeoff.ArOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.param.arorder.FinArOrderDetailQuery;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderDtlExVo;
import com.elitesland.fin.domain.entity.arorder.*;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 应收单.
 *
 * @author shihao.ma
 * @since 2023/9/14
 */
@Repository
public class ArOrderDetailRepoProc extends BaseRepoProc<ArOderExDtlDo> {

    private static final QArOderExDtlDo QDO = QArOderExDtlDo.arOderExDtlDo;
    private static final QArOrderExDo QMasExt = QArOrderExDo.arOrderExDo;
    private static final QArOrderDO QMas = QArOrderDO.arOrderDO;
    private static final QArOrderDtlDO QDetail = QArOrderDtlDO.arOrderDtlDO;

    protected ArOrderDetailRepoProc() {
        super(QDO);
    }

    /**
     * 查询应收单明细、明细扩展集合.
     *
     * @param query 查询条件
     * @return 查询结果集
     */
    public List<ArOrderDtlExVo> listArOrderDetail(FinArOrderDetailQuery query) {

        JPAQuery<ArOrderDtlExVo> select = jpaQueryFactory.select(Projections.bean(ArOrderDtlExVo.class,
                QDetail.id,
                QDetail.masId,
                QDetail.sourceNo,
                QDetail.sourceLine,
                QDetail.itemId,
                QDetail.itemCode,
                QDetail.itemName,
                QDetail.itemType,
                QDetail.smallCateCode,
                QDetail.smallCateName,
                QDetail.uom,
                QDetail.uomName,
                QDetail.qty,
                QDetail.exclTaxPrice,
                QDetail.price,
                QDetail.taxRate,
                QDetail.totalAmt,
                QDetail.exclTaxAmt,
                QDetail.taxAmt,
                QDetail.totalCurAmt,
                QDetail.exclTaxCurAmt,
                QDetail.taxCurAmt,
                QDetail.buCode,
                QDetail.buId,
                QDetail.buName,
                QDetail.expensesType,
                QDO.sendOrder,
                QDO.thirdOrderDtId,
                QDO.applicationDtId,
                QDO.orderCustomer,
                QDO.custCode,
                QDO.unitpriceBeforeTax,
                QDO.taxCode,
                QDO.invoiceNumber,
                QDO.invoiceType,
                QDO.reciveAgreement,
                QDO.businessCode,
                QDO.currCode,
                QDO.exchangeRate,
                QDO.startDate,
                QDO.paymentDueDate,
                QDO.verAmt,
                QDO.applyVerAmTing,
                QDO.unVerAmt,
                QDO.salSoDocNo
        ))
                .from(QDetail)
                .leftJoin(QDO).on(QDO.relateId.eq(QDetail.relateId));

        List<Predicate> predicates = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(query.getArDIds())) {
            predicates.add(QDetail.id.in(query.getArDIds()));
        }
        if (CollectionUtils.isNotEmpty(query.getMasIds())) {
            predicates.add(QDetail.masId.in(query.getMasIds()));
        }

        select.where(ExpressionUtils.allOf(predicates));
        return select.fetch();
    }

    /**
     * 查询应收单明细金额.
     *
     * @param arDId 明细ID
     * @return 查询结果
     */
    public ArOderExDtlDo getArOrderDetailAmt(Long arDId) {
        JPAQuery<ArOderExDtlDo> select = jpaQueryFactory.select(Projections.bean(ArOderExDtlDo.class,
                QDO.id.as("extId"),
                QDetail.totalAmt,
                QDO.verAmt,
                QDO.applyVerAmTing,
                QDO.auditDataVersion.as("version"),
                QDO.unVerAmt
        ))
                .from(QDetail)
                .leftJoin(QDO).on(QDO.relateId.eq(QDetail.relateId))
                .where(QDetail.id.eq(arDId));
        return select.fetchOne();
    }
    public ArOrderDtlDO getExtArOrderDetailAmt(Long arDId) {
        JPAQuery<ArOrderDtlDO> select = jpaQueryFactory.select(Projections.fields(ArOrderDtlDO.class,
                        QDetail.id,
                        QDetail.totalAmt,
                        QDetail.verAmt,
                        QDetail.applyVerAmTing,
                        QDetail.unVerAmt,
                        QDetail.auditDataVersion
                ))
                .from(QDetail)
                .where(QDetail.id.eq(arDId));
        return select.fetchOne();
    }
    public List<ArOderExDtlDo> getArOrderDetailAmt(Collection<Long> arDIds) {
        JPAQuery<ArOderExDtlDo> select = jpaQueryFactory.select(Projections.bean(ArOderExDtlDo.class,
                QDO.id.as("extId"),
                QDetail.totalAmt,
                QDetail.id.as("arDId"),
                QDO.verAmt,
                QDO.applyVerAmTing,
                QDO.auditDataVersion.as("version"),
                QDO.unVerAmt
        ))
                .from(QDetail)
                .leftJoin(QDO).on(QDO.relateId.eq(QDetail.relateId))
                .where(QDetail.id.in(arDIds));
        return select.fetch();
    }

    /**
     * 更新核销金额.
     *
     * @param update 更新结果
     * @return 更新条数
     */
    public long updateVerAmt(ArOrderAmtUpdateDTO update) {
        return jpaQueryFactory.update(QDO)
                .set(QDO.verAmt, update.getVerAmt())
                .set(QDO.applyVerAmTing, update.getVerAmting())
                .set(QDO.unVerAmt, update.getUnVerAmt())
                .set(QDO.auditDataVersion, update.getVersion() + 1)
                .where(QDO.id.eq(update.getArDId()).and(QDO.auditDataVersion.eq(update.getVersion())))
                .execute();
    }
    @Transactional(rollbackFor = Exception.class)
    public long updateExtVerAmt(ArOrderAmtUpdateDTO update) {
        return jpaQueryFactory.update(QDetail)
                .set(QDetail.verAmt, update.getVerAmt())
                .set(QDetail.applyVerAmTing, update.getVerAmting())
                .set(QDetail.unVerAmt, update.getUnVerAmt())
                .set(QDetail.auditDataVersion, update.getVersion() + 1)
                .where(QDetail.id.eq(update.getArDId()).and(QDetail.auditDataVersion.eq(update.getVersion())))
                .execute();
    }
    public long updateOrderExt(Long id, String state, Integer version) {
        return jpaQueryFactory.update(QMas)
                .set(QMas.verState, state)
                .set(QMas.auditDataVersion, version + 1)
                .where(QDO.id.eq(id).and(QDO.auditDataVersion.eq(version)))
                .execute();
    }

    public List<ArOderExDtlDo> listByMasIds(Collection<Long> masIds) {
        return super.getListByValue(QDO.masId, masIds);
    }
}
