package com.elitesland.fin.rpc.pur;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.pur.provider.PurSuppProvider;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/06/28
 * @Version 1.0
 * @Content:
 */
@Service
@AllArgsConstructor
@Slf4j
public class PurSuppOutServiceImpl implements PurSuppOutService{

    private final PurSuppProvider purSuppProvider;

    /**
     * 查询供应商基础信息接口
     *
     * @param suppCodes 供应商编号
     * @return
     */
    @Override
    public List<PurSuppBaseRpcDTO> findBaseSuppByCodes(List<String> suppCodes) {
        //log.info("调用采购域(findBaseSuppByCodes)查询供应商基础信息接口，时间：{}，入参：{}", LocalDateTime.now(), JSON.toJSONString(suppCodes));
        if (CollectionUtil.isEmpty(suppCodes)) {
            return Collections.EMPTY_LIST;
        }
        try {
            PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
            purSuppBaseRpcParam.setSuppCodes(suppCodes);
            ApiResult<List<PurSuppBaseRpcDTO>> apiResult = purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam);
            //log.info("调用采购域-findBaseSuppByCodes，时间：{}，出参：{}", LocalDateTime.now(), JSON.toJSONString(apiResult));
            if (apiResult.isSuccess()) {
                List<PurSuppBaseRpcDTO> rpcDTOList = apiResult.getData();
                if (CollectionUtil.isNotEmpty(rpcDTOList)) {
                    return rpcDTOList;
                }
            } else {
                throw new BusinessException(ApiCode.FAIL, "调用采购域(findBaseSuppByCodes)查询供应商失败：" + apiResult.getErrorMsg());
            }
        } catch (Exception e) {
            log.error("findBaseSuppByCodes error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用采购中心dubbo服务异常：" + e);
        }

        return Collections.EMPTY_LIST;
    }

    public List<PurSuppBaseRpcDTO> findBaseSuppByParam(PurSuppBaseRpcParam purSuppBaseRpcParam) {
        log.info("查询供应商信息参数:{}", JSONUtil.toJsonStr(purSuppBaseRpcParam));
        List<PurSuppBaseRpcDTO> data = new ArrayList<>();
        try {
            data = purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam).computeData();
            log.info("查询供应商信息结果:{}", JSONUtil.toJsonStr(data));
        } catch (Exception e) {
            throw new BusinessException("查询供应商信息失败", e);
        }
        return data;
    }


    @Override
    public Map<String,PurSuppBaseRpcDTO> findBaseSuppMapByCodes(List<String> suppCodes) {

        List<PurSuppBaseRpcDTO> rpcDTOList = this.findBaseSuppByCodes(suppCodes);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<>();
        }
        Map<String, PurSuppBaseRpcDTO> suppMap = rpcDTOList.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getSuppCode, t -> t, (t1, t2) -> t1));

        return suppMap;

    }

    /**
     * 查询供应商基础信息接口
     *
     * @param suppCodes 供应商编号
     * @return
     */
    @Override
    public List<PurSuppBaseRpcDTO> findSimpleRpcDtoByParam(List<String> suppCodes) {
        //log.info("调用采购域(findSimpleRpcDtoByParam)查询供应商基础信息接口，时间：{}，入参：{}", LocalDateTime.now(), JSON.toJSONString(suppCodes));
        if (CollectionUtil.isEmpty(suppCodes)) {
            return Collections.EMPTY_LIST;
        }
        try {
            PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
            purSuppBaseRpcParam.setSuppCodes(suppCodes);
            ApiResult<List<PurSuppBaseRpcDTO>> apiResult = purSuppProvider.findSimpleRpcDtoByParam(purSuppBaseRpcParam);
            //log.info("调用采购域-findSimpleRpcDtoByParam，时间：{}，出参：{}", LocalDateTime.now(), JSON.toJSONString(apiResult));
            if (apiResult.isSuccess()) {
                List<PurSuppBaseRpcDTO> rpcDTOList = apiResult.getData();
                if (CollectionUtil.isNotEmpty(rpcDTOList)) {
                    return rpcDTOList;
                }
            } else {
                throw new BusinessException(ApiCode.FAIL, "调用采购域(findSimpleRpcDtoByParam)查询供应商失败：" + apiResult.getErrorMsg());
            }
        } catch (Exception e) {
            log.error("findSimpleRpcDtoByParam error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用采购中心dubbo服务异常：" + e);
        }

        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String,PurSuppBaseRpcDTO> findSimpleSuppMapByCodes(List<String> suppCodes) {

        List<PurSuppBaseRpcDTO> rpcDTOList = this.findSimpleRpcDtoByParam(suppCodes);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<>();
        }
        Map<String, PurSuppBaseRpcDTO> suppMap = rpcDTOList.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getSuppCode, t -> t, (t1, t2) -> t1));

        return suppMap;

    }

    /**
     * 查询供应商基础信息接口
     *
     * @param suppIds 供应商编号
     * @return
     */
    @Override
    public List<PurSuppBaseRpcDTO> findSimpleRpcDtoBySuppId(List<Long> suppIds) {
        if (CollectionUtil.isEmpty(suppIds)) {
            return Collections.EMPTY_LIST;
        }
        try {
            PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
            purSuppBaseRpcParam.setSuppIds(suppIds);
            ApiResult<List<PurSuppBaseRpcDTO>> apiResult = purSuppProvider.findSimpleRpcDtoByParam(purSuppBaseRpcParam);
            if (apiResult.isSuccess()) {
                List<PurSuppBaseRpcDTO> rpcDTOList = apiResult.getData();
                if (CollectionUtil.isNotEmpty(rpcDTOList)) {
                    return rpcDTOList;
                }
            } else {
                throw new BusinessException(ApiCode.FAIL, "调用采购域(findSimpleRpcDtoBySuppId)查询供应商失败：" + apiResult.getErrorMsg());
            }
        } catch (Exception e) {
            log.error("findSimpleRpcDtoBySuppId error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用采购中心dubbo服务异常：" + e);
        }

        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<Long,PurSuppBaseRpcDTO> findSimpleSuppMapBySuppId(List<Long> suppIds) {

        List<PurSuppBaseRpcDTO> rpcDTOList = this.findSimpleRpcDtoBySuppId(suppIds);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<>();
        }
        Map<Long, PurSuppBaseRpcDTO> suppMap = rpcDTOList.stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getId, t -> t, (t1, t2) -> t1));

        return suppMap;

    }

}
