package com.elitesland.fin.infr.dto.recorder;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhiyu.he
 * @date 2022/4/13 11:00
 */
@Data
public class RecOrderDtlDTO implements Serializable {

    @ApiModelProperty("付款银行账号")
    private String es16;

    @ApiModelProperty("付款银行账户")
    private String es17;

    private static final long serialVersionUID = -1910795288494973785L;
    private Long id;

    private Long masId;

    @ApiModelProperty("收款方式")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String recType;
    private String recTypeName;

    @ApiModelProperty("收款类型")
    @SysCode(sys = "yst-sale", mod = "RECEIPT_TYPE")
    private String recKind;
    private String recKindName;

    private String recBank;

    private String recAccount;

    private String recFlow;

    private String sourceNo;

    private Long sourceId;

    private Integer sourceLine;

    private Long sourceLineId;

    private BigDecimal realRecAmt;

    private BigDecimal realRecCurAmt;

    private BigDecimal taxAmt;

    private BigDecimal taxRate;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    @ApiModelProperty("费用类型")
    @SysCode(sys = "yst-fin", mod = "EXPENSES_TYPE")
    private String expensesType;
    private String expensesTypeName;

    private BigDecimal taxCurAmt;

    private String remark;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;
    @ApiModelProperty("未核销金额")
    @Column(name = "un_ver_amt", columnDefinition = "decimal(16,4)  comment '未核销金额'")
    private BigDecimal unVerAmt;

    @ApiModelProperty("已核销金额")
    @Column(name = "ver_amt", columnDefinition = "decimal(16,4)  comment '已核销金额'")
    private BigDecimal verAmt;

    @ApiModelProperty("核销申请中金额")
    @Column(name = "ver_amting", columnDefinition = "decimal(16,4)  comment '核销申请中金额'")
    private BigDecimal applyVerAmTing;
}
