package com.elitesland.fin.infr.repo.arorder;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.fin.domain.entity.arorder.ArOrderRecordDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderRecordDO;
import com.elitesland.fin.domain.param.arorder.ArOrderRecordParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/02/28
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class ArOrderRecordRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QArOrderRecordDO qArOrderRecordDO = QArOrderRecordDO.arOrderRecordDO;


    public List<ArOrderRecordDO> selectArOrderRecordByParam(ArOrderRecordParam param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (CollectionUtil.isNotEmpty(param.getSourceDocTypeList())) {
            predicate = ExpressionUtils.and(predicate, qArOrderRecordDO.sourceDocType.in(param.getSourceDocTypeList()));
        }
        if (CollectionUtil.isNotEmpty(param.getSourceDocStatusList())) {
            predicate = ExpressionUtils.and(predicate, qArOrderRecordDO.sourceDocStatus.in(param.getSourceDocStatusList()));
        }
        if (CollectionUtil.isNotEmpty(param.getCreateModeList())) {
            predicate = ExpressionUtils.and(predicate, qArOrderRecordDO.createMode.in(param.getCreateModeList()));
        }
        if (CollectionUtil.isNotEmpty(param.getSourceNoList())) {
            predicate = ExpressionUtils.and(predicate, qArOrderRecordDO.sourceNo.in(param.getSourceNoList()));
        }
        if (CollectionUtil.isNotEmpty(param.getOuCodeList())) {
            predicate = ExpressionUtils.and(predicate, qArOrderRecordDO.ouCode.in(param.getOuCodeList()));
        }
        if (CollectionUtil.isNotEmpty(param.getOuIdList())) {
            predicate = ExpressionUtils.and(predicate, qArOrderRecordDO.ouId.in(param.getOuIdList()));
        }
        if (CollectionUtil.isNotEmpty(param.getArFlagList())) {
            predicate = ExpressionUtils.and(predicate, qArOrderRecordDO.arFlag.in(param.getArFlagList()));
        }

        return jpaQueryFactory.select(qArOrderRecordDO)
                .from(qArOrderRecordDO)
                .where(predicate)
                .fetch();
    }

    /**
     * 更新是否生成应收单标记
     * @param id 记录表ID
     * @param arFlag 是否生成应收单标记
     */
    public void updateArFlagById(Long id, String arFlag){
        jpaQueryFactory
                .update(qArOrderRecordDO)
                .set(qArOrderRecordDO.arFlag, arFlag)
                .where(qArOrderRecordDO.id.eq(id))
                .execute();
    }

    /**
     * 更新是否生成应收单标记和失败原因
     * @param id 记录表ID
     * @param arFlag 是否生成应收单标记
     * @param failMsg 失败原因
     */
    public void updateArFlagAndFailMsgById(Long id, String arFlag, String failMsg){
        jpaQueryFactory
                .update(qArOrderRecordDO)
                .set(qArOrderRecordDO.arFlag, arFlag)
                .set(qArOrderRecordDO.failMsg, failMsg)
                .where(qArOrderRecordDO.id.eq(id))
                .execute();
    }


    public void updateDeleteFlagById(List<Long> ids) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qArOrderRecordDO)
                .set(qArOrderRecordDO.deleteFlag, 1)
                .where(qArOrderRecordDO.id.in(ids));
        jpaUpdateClause.execute();
    }


    public void updateDeleteFlagBySourceNo(String sourceNo) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qArOrderRecordDO)
                .set(qArOrderRecordDO.deleteFlag, 1)
                .where(qArOrderRecordDO.sourceNo.eq(sourceNo));
        jpaUpdateClause.execute();
    }

    public void updateDeleteFlagBySourceNos(List<String> sourceNos) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qArOrderRecordDO)
                .set(qArOrderRecordDO.deleteFlag, 1)
                .where(qArOrderRecordDO.sourceNo.in(sourceNos));
        jpaUpdateClause.execute();
    }

    public List<Long> selectIdBySourceNo(List<String> sourceNos) {
        return jpaQueryFactory.select(qArOrderRecordDO.id)
                .from(qArOrderRecordDO)
                .where(qArOrderRecordDO.sourceNo.in(sourceNos))
                .fetch();
    }

}
