package com.elitesland.fin.repo.creditaccountflow;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowPageParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import com.elitesland.fin.entity.creditaccountflow.QCreditAccountFlowDO;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.elitesland.fin.utils.PartitionJpaUtil;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class CreditAccountFlowRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QCreditAccountFlowDO qCreditAccountFlowDO = QCreditAccountFlowDO.creditAccountFlowDO;

    public PagingVO<CreditAccountFlowDTO> page(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> where = where(creditAccountFlowPageParam);
        JPAQuery<CreditAccountFlowDTO> query = select(CreditAccountFlowDTO.class).where(ExpressionUtils.allOf(where));
        //数据权限
        BusinessSecurityUtil.where(query , CreditAccountFlowDO.class);
        //分区查询字段
        PartitionJpaUtil.appendYmConditionToPredicate(query, CreditAccountFlowDO.class, creditAccountFlowPageParam);
        creditAccountFlowPageParam.setPaging(query);
        creditAccountFlowPageParam.fillOrders(query, qCreditAccountFlowDO);
        return PagingVO.<CreditAccountFlowDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public CreditAccountFlowVO selectByAccCode(String accCode) {
        return select(CreditAccountFlowVO.class)
                .where(qCreditAccountFlowDO.creditAccountCode.eq(accCode))
                .where(qCreditAccountFlowDO.deleteFlag.eq(0).or(qCreditAccountFlowDO.deleteFlag.isNull()))
                .orderBy(qCreditAccountFlowDO.createTime.desc())
                .fetchFirst();
    }

    public List<CreditAccountFlowVO> selectListByParam(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> where = where(creditAccountFlowPageParam);
        JPAQuery<CreditAccountFlowVO> query = select(CreditAccountFlowVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }


    private List<Predicate> where(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> predicates = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getRootDocNos())){
            predicates.add(qCreditAccountFlowDO.rootDocNo.in(creditAccountFlowPageParam.getRootDocNos()));
        }
        //对象名称
        if (StringUtils.isNotEmpty(creditAccountFlowPageParam.getObjectName())) {
            predicates.add(qCreditAccountFlowDO.objectName.like(StringUtil.buildLikeString(creditAccountFlowPageParam.getObjectName())));
        }
        if(CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getObjectNameList())){
            predicates.add(qCreditAccountFlowDO.objectName.in(creditAccountFlowPageParam.getObjectNameList()));
        }
        if(CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getObjectCodeList())){
            predicates.add(qCreditAccountFlowDO.objectCode.in(creditAccountFlowPageParam.getObjectCodeList()));
        }
        //账户名称
        if (!StringUtils.isEmpty(creditAccountFlowPageParam.getCreditAccountName())) {
            predicates.add(qCreditAccountFlowDO.creditAccountName.like(StringUtil.buildLikeString(creditAccountFlowPageParam.getCreditAccountName())));
        }
        if(CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getCreditAccountNameList())){
            predicates.add(qCreditAccountFlowDO.creditAccountName.in(creditAccountFlowPageParam.getCreditAccountNameList()));
        }
        if(CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getCreditAccountCodeList())){
            predicates.add(qCreditAccountFlowDO.creditAccountCode.in(creditAccountFlowPageParam.getCreditAccountCodeList()));
        }
        if (!StringUtils.isEmpty(creditAccountFlowPageParam.getCreditAccountCode())) {
            predicates.add(qCreditAccountFlowDO.creditAccountCode.eq(creditAccountFlowPageParam.getCreditAccountCode()));
        }
        //交易类型
        if (!StringUtils.isEmpty(creditAccountFlowPageParam.getTransactionType())) {
            predicates.add(qCreditAccountFlowDO.transactionType.eq(creditAccountFlowPageParam.getTransactionType()));
        }
        if(CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getTransactionTypeList())){
            predicates.add(qCreditAccountFlowDO.transactionType.in(creditAccountFlowPageParam.getTransactionTypeList()));
        }
        //开始交易日期
        if (creditAccountFlowPageParam.getTransactionTimeS() != null) {
            predicates.add(qCreditAccountFlowDO.transactionTime.goe(creditAccountFlowPageParam.getTransactionTimeS()));
        }

        //结束交易日期
        if (creditAccountFlowPageParam.getTransactionTimeE() != null) {
            predicates.add(qCreditAccountFlowDO.transactionTime.loe(creditAccountFlowPageParam.getTransactionTimeE()));
        }
        if (creditAccountFlowPageParam.getAuditDateS() != null) {
            predicates.add(qCreditAccountFlowDO.auditDate.goe(creditAccountFlowPageParam.getAuditDateS()));
        }

        if (creditAccountFlowPageParam.getAuditDateE() != null) {
            predicates.add(qCreditAccountFlowDO.auditDate.loe(creditAccountFlowPageParam.getAuditDateE()));
        }
        //发生金额
        if (creditAccountFlowPageParam.getAmountFrom() != null) {
            predicates.add(qCreditAccountFlowDO.amount.goe(creditAccountFlowPageParam.getAmountFrom()));
        }

        //发生金额
        if (creditAccountFlowPageParam.getAmountTo() != null) {
            predicates.add(qCreditAccountFlowDO.amount.loe(creditAccountFlowPageParam.getAmountTo()));
        }

        // 账户类型
        if (StrUtil.isNotBlank(creditAccountFlowPageParam.getCreditAccountType())) {
            predicates.add(qCreditAccountFlowDO.creditAccountType.eq(creditAccountFlowPageParam.getCreditAccountType()));
        }
        if(CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getCreditAccountTypeList())){
            predicates.add(qCreditAccountFlowDO.creditAccountType.in(creditAccountFlowPageParam.getCreditAccountTypeList()));
        }
        // 来源单号
        if (StrUtil.isNotBlank(creditAccountFlowPageParam.getSourceNo())) {
            predicates.add(qCreditAccountFlowDO.sourceNo.like("%" + creditAccountFlowPageParam.getSourceNo() + "%"));
        }
        if(CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getSourceNoList())){
            predicates.add(qCreditAccountFlowDO.sourceNo.in(creditAccountFlowPageParam.getSourceNoList()));
        }
        // 来源单号
        if (StrUtil.isNotBlank(creditAccountFlowPageParam.getFlowNo())) {
            predicates.add(qCreditAccountFlowDO.flowNo.like("%" + creditAccountFlowPageParam.getFlowNo() + "%"));
        }

        // 来源单据类型
        if (CollectionUtil.isNotEmpty(creditAccountFlowPageParam.getSourceDocList())) {
            predicates.add(qCreditAccountFlowDO.sourceDoc.in(creditAccountFlowPageParam.getSourceDocList()));
        }

        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getIds())) {
            predicates.add(qCreditAccountFlowDO.id.in(creditAccountFlowPageParam.getIds()));
        }
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate= CustomFieldJpaServiceUtil.getPredicate(creditAccountFlowPageParam.getConditions(), CreditAccountFlowDO.class);
        if(customFieldPredicate!=null){
            predicates.add(customFieldPredicate);
            //predicate= ExpressionUtils.and(predicate,customFieldPredicate);
        }
       //增加扩展字段查询条件end
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qCreditAccountFlowDO.id,
                qCreditAccountFlowDO.flowNo,
                qCreditAccountFlowDO.transactionType,
                qCreditAccountFlowDO.amount,
                qCreditAccountFlowDO.transactionTime,
                qCreditAccountFlowDO.creditAccountCode,
                qCreditAccountFlowDO.creditAccountName,
                qCreditAccountFlowDO.creditAccountType,
                qCreditAccountFlowDO.sourceNo,
                qCreditAccountFlowDO.sourceDoc,
                qCreditAccountFlowDO.remark,
                qCreditAccountFlowDO.createTime,
                qCreditAccountFlowDO.createUserId,
                qCreditAccountFlowDO.creator,
                qCreditAccountFlowDO.modifyTime,
                qCreditAccountFlowDO.modifyUserId,
                qCreditAccountFlowDO.updater,
                qCreditAccountFlowDO.deleteFlag,
                qCreditAccountFlowDO.ouCode,
                qCreditAccountFlowDO.creditAccountLimit,
                qCreditAccountFlowDO.creditAccountUsedLimit,
                qCreditAccountFlowDO.creditAccountOccupancyLimit,
                qCreditAccountFlowDO.creditAccountAvailableLimit,
                qCreditAccountFlowDO.auditUserId,
                qCreditAccountFlowDO.auditUserName,
                qCreditAccountFlowDO.auditDate,
                qCreditAccountFlowDO.orderState,
                qCreditAccountFlowDO.creditAccountRuleCode,
                qCreditAccountFlowDO.priorityNo,
                qCreditAccountFlowDO.ouName,
                qCreditAccountFlowDO.objectCode,
                qCreditAccountFlowDO.objectName,
                qCreditAccountFlowDO.objectType,
                qCreditAccountFlowDO.buCode,
                qCreditAccountFlowDO.buName,
                qCreditAccountFlowDO.saleUser,
                qCreditAccountFlowDO.sourceId,
                qCreditAccountFlowDO.sourceDocStatus,
                qCreditAccountFlowDO.extensionInfo,
                qCreditAccountFlowDO.rootDocNo,
                qCreditAccountFlowDO.rootDocId,
                qCreditAccountFlowDO.rootDocType

        )).from(qCreditAccountFlowDO);
    }

/*    public PagingVO<CreditAccountFlowVO> dealerPage(CreditAccountFlowParam creditAccountFlowParam) {
        List<Predicate> where = where(creditAccountFlowParam);
        JPAQuery<CreditAccountFlowVO> query = dealerSelect(CreditAccountFlowVO.class).where(ExpressionUtils.allOf(where));
        creditAccountFlowParam.setPaging(query);
        creditAccountFlowParam.fillOrders(query, qCreditAccountFlowDO);
        return PagingVO.<CreditAccountFlowVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }*/

    private <T> JPAQuery<T> dealerSelect(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qCreditAccountFlowDO.id,
                qCreditAccountFlowDO.flowNo,
                qCreditAccountFlowDO.transactionType,
                qCreditAccountFlowDO.amount,
                qCreditAccountFlowDO.transactionTime,
                qCreditAccountFlowDO.creditAccountCode,
                qCreditAccountFlowDO.creditAccountName,
                qCreditAccountFlowDO.sourceNo,
                qCreditAccountFlowDO.sourceDoc
        )).from(qCreditAccountFlowDO);
    }


/*    public List<CreditAccountFlowVO> dealerSelectAmt(CreditAccountFlowParam creditAccountFlowParam) {
        List<Predicate> where = where(creditAccountFlowParam);
        JPAQuery<CreditAccountFlowVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CreditAccountFlowVO.class,
                qCreditAccountFlowDO.id,
                qCreditAccountFlowDO.amount
        )).from(qCreditAccountFlowDO);
        jpaQuery.where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }*/

    public void approveAccountFlow(CreditAccountFlowParam creditAccountFlowParam) {
        jpaQueryFactory.update(qCreditAccountFlowDO)
                .set(qCreditAccountFlowDO.orderState, creditAccountFlowParam.getOrderState())
                .set(qCreditAccountFlowDO.auditUserId, creditAccountFlowParam.getAuditUserId())
                .set(qCreditAccountFlowDO.auditUserName, creditAccountFlowParam.getAuditUserName())
                .set(qCreditAccountFlowDO.auditDate, creditAccountFlowParam.getAuditDate())
                .where(qCreditAccountFlowDO.id.eq(creditAccountFlowParam.getId()))
                .execute();
    }

    public List<CreditAccountFlowVO> queryCreditAccountFlowVO(CreditAccountFlowParam creditAccountFlowParam) {
        JPAQuery<CreditAccountFlowVO> query = select(CreditAccountFlowVO.class);
        if (creditAccountFlowParam.getSourceId() != null) {
            query.where(qCreditAccountFlowDO.sourceId.eq(creditAccountFlowParam.getSourceId()));
        }
        if (StringUtils.isNotEmpty(creditAccountFlowParam.getSourceDoc())) {
            query.where(qCreditAccountFlowDO.sourceDoc.eq(creditAccountFlowParam.getSourceDoc()));
        }
        if (StringUtils.isNotEmpty(creditAccountFlowParam.getSourceDocStatus())) {
            query.where(qCreditAccountFlowDO.sourceDocStatus.eq(creditAccountFlowParam.getSourceDocStatus()));
        }
        if (StringUtils.isNotEmpty(creditAccountFlowParam.getCreditAccountType())) {
            query.where(qCreditAccountFlowDO.creditAccountType.eq(creditAccountFlowParam.getCreditAccountType()));
        }
        if (StringUtils.isNotEmpty(creditAccountFlowParam.getSourceNo())) {
            query.where(qCreditAccountFlowDO.sourceNo.eq(creditAccountFlowParam.getSourceNo()));
        }
        return query.fetch();
    }

    public void updateCreditAccountFlowAmount(CreditAccountFlowParam creditAccountFlowParam) {
        jpaQueryFactory.update(qCreditAccountFlowDO)
                .set(qCreditAccountFlowDO.creditAccountLimit, creditAccountFlowParam.getCreditAccountLimit())
                .set(qCreditAccountFlowDO.creditAccountUsedLimit, creditAccountFlowParam.getCreditAccountUsedLimit())
                .set(qCreditAccountFlowDO.creditAccountOccupancyLimit, creditAccountFlowParam.getCreditAccountOccupancyLimit())
                .set(qCreditAccountFlowDO.creditAccountAvailableLimit, creditAccountFlowParam.getCreditAccountAvailableLimit())
                .where(qCreditAccountFlowDO.creditAccountCode.eq(creditAccountFlowParam.getCreditAccountCode())
                        .and(qCreditAccountFlowDO.orderState.eq(creditAccountFlowParam.getOrderState())))
                .execute();
    }
    public void updateCreditAccountFlowAmountById(CreditAccountFlowParam creditAccountFlowParam) {
        jpaQueryFactory.update(qCreditAccountFlowDO)
                .set(qCreditAccountFlowDO.creditAccountLimit, creditAccountFlowParam.getCreditAccountLimit())
                .set(qCreditAccountFlowDO.creditAccountUsedLimit, creditAccountFlowParam.getCreditAccountUsedLimit())
                .set(qCreditAccountFlowDO.creditAccountOccupancyLimit, creditAccountFlowParam.getCreditAccountOccupancyLimit())
                .set(qCreditAccountFlowDO.creditAccountAvailableLimit, creditAccountFlowParam.getCreditAccountAvailableLimit())
                .set(qCreditAccountFlowDO.orderState, creditAccountFlowParam.getOrderState())
                .set(qCreditAccountFlowDO.auditUserId, creditAccountFlowParam.getAuditUserId())
                .set(qCreditAccountFlowDO.auditUserName, creditAccountFlowParam.getAuditUserName())
                .set(qCreditAccountFlowDO.auditDate, creditAccountFlowParam.getAuditDate())
                .where(qCreditAccountFlowDO.id.eq(creditAccountFlowParam.getId())
                        .and(qCreditAccountFlowDO.orderState.eq(UdcEnum.APPLY_STATUS_DOING.getValueCode())))
                .execute();
    }

    public List<CreditAccountFlowVO> selectListByQueryParam(CreditAccountFlowParam queryParam) {
        JPAQuery<CreditAccountFlowVO> query = select(CreditAccountFlowVO.class);

        if (StringUtils.isNotEmpty(queryParam.getSourceNo())) {
            query.where(qCreditAccountFlowDO.sourceNo.eq(queryParam.getSourceNo()));
        }
        if (StringUtils.isNotEmpty(queryParam.getCreditAccountType())) {
            query.where(qCreditAccountFlowDO.creditAccountType.eq(queryParam.getCreditAccountType()));
        }
        if (StringUtils.isNotEmpty(queryParam.getFlowNo())) {
            query.where(qCreditAccountFlowDO.flowNo.eq(queryParam.getFlowNo()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getFlowNoList())) {
            query.where(qCreditAccountFlowDO.flowNo.in(queryParam.getFlowNoList()));
        }
        return query.fetch();
    }

    public CreditAccountFlowVO selectPreviousRepairAmtByParam(CreditAccountFlowParam flowQueryParam) {
        JPAQuery<CreditAccountFlowVO> query = select(CreditAccountFlowVO.class);
        if (!StringUtils.isEmpty(flowQueryParam.getCreditAccountCode())) {
            query.where(qCreditAccountFlowDO.creditAccountCode.eq(flowQueryParam.getCreditAccountCode()));
        }
        query.where(qCreditAccountFlowDO.auditDate.isNotNull());
        return query.orderBy(qCreditAccountFlowDO.auditDate.desc())
                .fetchFirst();
    }


    public List<CreditAccountFlowVO> selectRepairAfterPage(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> where = selectRepairAfterPageWhere(creditAccountFlowPageParam);
        JPAQuery<CreditAccountFlowVO> query = select(CreditAccountFlowVO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(qCreditAccountFlowDO.auditDate.desc());
        creditAccountFlowPageParam.setPaging(query);

        return query.fetch();
    }

    private List<Predicate> selectRepairAfterPageWhere(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(qCreditAccountFlowDO.auditDate.isNotNull());
        if (!CollectionUtils.isEmpty(creditAccountFlowPageParam.getFlowNoList())) {
            predicates.add(qCreditAccountFlowDO.flowNo.in(creditAccountFlowPageParam.getFlowNoList()));
        }
        if (Objects.nonNull(creditAccountFlowPageParam.getRepairTime())) {
            predicates.add(qCreditAccountFlowDO.auditDate.gt(creditAccountFlowPageParam.getRepairTime()));
        }
        if (!StringUtils.isEmpty(creditAccountFlowPageParam.getCreditAccountCode())) {
            predicates.add(qCreditAccountFlowDO.creditAccountCode.eq(creditAccountFlowPageParam.getCreditAccountCode()));
        }
        if (!CollectionUtils.isEmpty(creditAccountFlowPageParam.getCreditAccountCodeList())) {
            predicates.add(qCreditAccountFlowDO.creditAccountCode.in(creditAccountFlowPageParam.getCreditAccountCodeList()));
        }

        return predicates;
    }

    public List<CreditAccountFlowVO> selectRepairAfter(CreditAccountFlowParam flowPageParam) {
        List<Predicate> where = selectRepairAfterWhere(flowPageParam);
        JPAQuery<CreditAccountFlowVO> query = select(CreditAccountFlowVO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(qCreditAccountFlowDO.auditDate.desc());

        return query.fetch();
    }

    private List<Predicate> selectRepairAfterWhere(CreditAccountFlowParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(qCreditAccountFlowDO.auditDate.isNotNull());
        if (!CollectionUtils.isEmpty(pageParam.getFlowNoList())) {
            predicates.add(qCreditAccountFlowDO.flowNo.in(pageParam.getFlowNoList()));
        }
        if (Objects.nonNull(pageParam.getRepairTime())) {
            predicates.add(qCreditAccountFlowDO.auditDate.goe(pageParam.getRepairTime()));
        }
        if (!StringUtils.isEmpty(pageParam.getCreditAccountCode())) {
            predicates.add(qCreditAccountFlowDO.creditAccountCode.eq(pageParam.getCreditAccountCode()));
        }
        if (!CollectionUtils.isEmpty(pageParam.getCreditAccountCodeList())) {
            predicates.add(qCreditAccountFlowDO.creditAccountCode.in(pageParam.getCreditAccountCodeList()));
        }

        return predicates;
    }

    public void updateOccupancyAndAvailableAndAmountById(BigDecimal creditAccountOccupancyLimit, BigDecimal creditAccountAvailableLimit,
                                                         BigDecimal amount, Long id) {
        jpaQueryFactory.update(qCreditAccountFlowDO)
                .set(qCreditAccountFlowDO.creditAccountOccupancyLimit, creditAccountOccupancyLimit)
                .set(qCreditAccountFlowDO.creditAccountAvailableLimit, creditAccountAvailableLimit)
                .set(qCreditAccountFlowDO.amount, amount)
                .where(qCreditAccountFlowDO.id.eq(id))
                .execute();
    }

    public void updateAccountAndAvailableAndAmountById(BigDecimal creditAccountLimit,BigDecimal creditAccountAvailableLimit,
                                                       BigDecimal amount, Long id) {
        jpaQueryFactory.update(qCreditAccountFlowDO)
                .set(qCreditAccountFlowDO.creditAccountLimit, creditAccountLimit)
                .set(qCreditAccountFlowDO.creditAccountAvailableLimit, creditAccountAvailableLimit)
                .set(qCreditAccountFlowDO.amount, amount)
                .where(qCreditAccountFlowDO.id.eq(id))
                .execute();
    }

    public void updateUsedAndAvailableAndAmountById(BigDecimal creditAccountUsedLimit,BigDecimal creditAccountAvailableLimit,
                                                       BigDecimal amount, Long id) {
        jpaQueryFactory.update(qCreditAccountFlowDO)
                .set(qCreditAccountFlowDO.creditAccountUsedLimit, creditAccountUsedLimit)
                .set(qCreditAccountFlowDO.creditAccountAvailableLimit, creditAccountAvailableLimit)
                .set(qCreditAccountFlowDO.amount, amount)
                .where(qCreditAccountFlowDO.id.eq(id))
                .execute();
    }

    public void updateOccupancyAndAvailableById(BigDecimal creditAccountOccupancyLimit, BigDecimal creditAccountAvailableLimit,
                                                         Long id) {
        jpaQueryFactory.update(qCreditAccountFlowDO)
                .set(qCreditAccountFlowDO.creditAccountOccupancyLimit, creditAccountOccupancyLimit)
                .set(qCreditAccountFlowDO.creditAccountAvailableLimit, creditAccountAvailableLimit)
                .where(qCreditAccountFlowDO.id.eq(id))
                .execute();
    }

    public void updateAccountAndAvailableById(BigDecimal creditAccountLimit,BigDecimal creditAccountAvailableLimit,
                                                       Long id) {
        jpaQueryFactory.update(qCreditAccountFlowDO)
                .set(qCreditAccountFlowDO.creditAccountLimit, creditAccountLimit)
                .set(qCreditAccountFlowDO.creditAccountAvailableLimit, creditAccountAvailableLimit)
                .where(qCreditAccountFlowDO.id.eq(id))
                .execute();
    }

    public void updateUsedAndAvailableById(BigDecimal creditAccountUsedLimit,BigDecimal creditAccountAvailableLimit,
                                                    Long id) {
        jpaQueryFactory.update(qCreditAccountFlowDO)
                .set(qCreditAccountFlowDO.creditAccountUsedLimit, creditAccountUsedLimit)
                .set(qCreditAccountFlowDO.creditAccountAvailableLimit, creditAccountAvailableLimit)
                .where(qCreditAccountFlowDO.id.eq(id))
                .execute();
    }


    public PagingVO<CreditAccountFlowDTO> appPage(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> where = where(creditAccountFlowPageParam);
        JPAQuery<CreditAccountFlowDTO> query = select(CreditAccountFlowDTO.class).where(ExpressionUtils.allOf(where));
        creditAccountFlowPageParam.setPaging(query);
        creditAccountFlowPageParam.fillOrders(query, qCreditAccountFlowDO);
        return PagingVO.<CreditAccountFlowDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids) {
        jpaQueryFactory.update(qCreditAccountFlowDO)
                .set(qCreditAccountFlowDO.deleteFlag, deleteFlag)
                .where(qCreditAccountFlowDO.id.in(ids))
                .execute();
    }

    public List<CreditAccountFlowVO> findBySourceIds(List<Long> ids) {
        return jpaQueryFactory.select(Projections.bean(CreditAccountFlowVO.class,
                        qCreditAccountFlowDO.id,
                        qCreditAccountFlowDO.creditAccountCode,
                        qCreditAccountFlowDO.sourceId,
                        qCreditAccountFlowDO.sourceNo
                        ))
                .from(qCreditAccountFlowDO)
                .where(qCreditAccountFlowDO.sourceId.in(ids))
                .fetch();
    }
}
