package com.elitesland.fin.infr.dto.payorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:49
 */
@Data
public class SyncRecordDTO implements Serializable {

    private static final long serialVersionUID = -1123102269530735364L;

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("付款单ID")
    private Long payOrderId;

    @ApiModelProperty("付款单单号")
    private String payOrderNo;

    @ApiModelProperty("流水号")
    private String businessNo;

    @ApiModelProperty("序号")
    private Integer seqNo;

    @ApiModelProperty("同步状态")
    @SysCode(sys = "yst-fin", mod = "PAY_ORDER_SYNC_STATUS")
    private String syncStatus;
    private String syncStatusName;

    @ApiModelProperty("异常原因")
    private String syncError;

    @ApiModelProperty("外部系统ID")
    private String outSysKey;

}
