package com.elitesland.fin.application.facade.dto.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAbstractDetailVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
public class FinAbstractDTO extends BaseModelDTO {

    @ApiModelProperty("编码")
    private String code;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("事件表单ID")
    private Long eventId;

    @ApiModelProperty("事件表单名称")
    private String eventName;

    @ApiModelProperty("状态（0-草稿，1-启用，2-停用）")
    @SysCode(sys = "yst-fin",mod = "ABSTRACT_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("明细")
    private List<FinAbstractDetailVO> detailList;
}
