package com.elitesland.fin.application.facade.excel.convert;

import com.elitesland.fin.utils.excel.convert.Converter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;

public class DateTimeToDateConverter extends Converter<LocalDateTime, LocalDate, Void> {
    @Override
    public LocalDate convert(LocalDateTime value) {
        return getDate(value);
    }
    
    private LocalDate getDate(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return value.toLocalDate();
    }
}
