package com.elitesland.fin.application.service.account;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.TcStatementAccountConvert;
import com.elitesland.fin.application.facade.vo.account.TcStatementAccountVO;
import com.elitesland.fin.entity.account.TcStatementAccountDO;
import com.elitesland.fin.infinity.utils.CsvReadListener;
import com.elitesland.fin.infinity.utils.CsvReaderUtil;
import com.elitesland.fin.infinity.utils.SshConnectionManager;
import com.elitesland.fin.param.account.TcStatementAccountPageParam;
import com.elitesland.fin.repo.account.TcStatementAccountRepo;
import com.elitesland.fin.repo.account.TcStatementAccountRepoProc;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.xfer.FileSystemFile;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 天龙对账单服务实现类
 *
 * @author elitesland
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TcStatementAccountServiceImpl implements TcStatementAccountService {


    private final TcStatementAccountRepo tcStatementAccountRepo;

    private final TcStatementAccountRepoProc tcStatementAccountRepoProc;

    private final OrgStoreRpcService orgStoreRpcService;



    @Override
    @SysCodeProc
    public PagingVO<TcStatementAccountVO> page(TcStatementAccountPageParam pageParam) {

        PagingVO<TcStatementAccountDO> result = tcStatementAccountRepoProc.page(pageParam);


        PagingVO<TcStatementAccountVO> resultVO = result.map(TcStatementAccountConvert.INSTANCE::doToVO);
        return resultVO;
    }

    @Override
    @Transactional( rollbackFor = {Exception.class})
    public void sync(String fileName) throws IOException {
        if (fileName == null){
            throw new BusinessException("请选择文件");
        }

        ArrayList<TcStatementAccountVO> tcStatementAccountVOS = new ArrayList<>();
        SFTPClient sftp = SshConnectionManager.getSshVo().getSftp();

        File tempFile = Files.createTempFile("sftp-", ".tmp").toFile();
//        tempFile.deleteOnExit();
        List<RemoteResourceInfo> files = sftp.ls("/nongxiaoguo/nongxiaoguo");
        String path = null;
        if (StringUtils.isNotBlank(fileName)) {
            List<RemoteResourceInfo> targetFiles = files.stream().filter(v -> v.getName().contains(fileName)).collect(Collectors.toList());
            path = targetFiles.get(targetFiles.size()-1).getPath();
        }
        if (path == null){
            throw new BusinessException("未找到文件");
        }
        sftp.get(path,  new FileSystemFile(tempFile));
        CsvReaderUtil.readCsv(tempFile.getPath(), TcStatementAccountVO.class, new CsvReadListener<TcStatementAccountVO>() {
            private int count = 0;
            @Override
            public void invoke(TcStatementAccountVO data) {
                count++;
                log.info("读取到数据: " + data);
                tcStatementAccountVOS.add(data);
                // 可以在这里添加业务逻辑处理
            }

            @Override
            public void doAfterAllAnalysed() {
                log.info("CSV文件读取完成，共读取 " + count + " 条数据");
            }
        });
        OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
        orgStoreBaseRpcParam.setStoreCodeList( tcStatementAccountVOS.stream().map(TcStatementAccountVO::getStoreCode).collect(Collectors.toList()));
        Map<String, OrgStoreBaseRpcDTO> storeMap = orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam).computeData().stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, v -> v));
        tcStatementAccountVOS.forEach(t -> {
            if (storeMap.containsKey(t.getStoreCode())){
                t.setStoreBusinessType(storeMap.get(t.getStoreCode()).getStoreType2());
            }
        });
        tcStatementAccountRepo.saveAll(TcStatementAccountConvert.INSTANCE.voListToDOList(tcStatementAccountVOS));
    }

}
