package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_journal")
@org.hibernate.annotations.Table(appliesTo = "fin_journal", comment = "凭证")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinJournalDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "doc_num", columnDefinition = "varchar(20) comment '单据编码'")
    private String docNum;

    @Column(name = "doc_type", columnDefinition = "varchar(32) comment '单据类型'")
    private String docType;

    @Column(name = "system_source_code", columnDefinition = "varchar(32) comment '来源系统编码'")
    private String systemSourceCode;

    @Column(name = "system_source_name", columnDefinition = "varchar(32) comment '来源系统名称'")
    private String systemSourceName;

    @Column(name = "voucher_type_code", columnDefinition = "varchar(32) comment '凭证编码'")
    private String voucherTypeCode;

    @Column(name = "voucher_type_name", columnDefinition = "varchar(32) comment '凭证类型'")
    private String voucherTypeName;

    @Column(name = "segment1", columnDefinition = "varchar(32) comment '核算维度1'")
    private String segment1;

    @Column(name = "segment2", columnDefinition = "varchar(32) comment '核算维度2'")
    private String segment2;

    @Column(name = "segment3", columnDefinition = "varchar(32) comment '核算维度3'")
    private String segment3;

    @Column(name = "segment4", columnDefinition = "varchar(32) comment '核算维度4'")
    private String segment4;

    @Column(name = "segment5", columnDefinition = "varchar(32) comment '核算维度5'")
    private String segment5;

    @Column(name = "segment6", columnDefinition = "varchar(32) comment '核算维度6'")
    private String segment6;

    @Column(name = "segment7", columnDefinition = "varchar(32) comment '核算维度7'")
    private String segment7;

    @Column(name = "segment8", columnDefinition = "varchar(32) comment '核算维度8'")
    private String segment8;

    @Column(name = "segment9", columnDefinition = "varchar(32) comment '核算维度9'")
    private String segment9;

    @Column(name = "segment10", columnDefinition = "varchar(32) comment '核算维度10'")
    private String segment10;

    @Column(name = "segment11", columnDefinition = "varchar(32) comment '核算维度11'")
    private String segment11;

    @Column(name = "segment12", columnDefinition = "varchar(32) comment '核算维度12'")
    private String segment12;

    @Column(name = "segment13", columnDefinition = "varchar(32) comment '核算维度13'")
    private String segment13;

    @Column(name = "segment14", columnDefinition = "varchar(32) comment '核算维度14'")
    private String segment14;

    @Column(name = "segment15", columnDefinition = "varchar(32) comment '核算维度15'")
    private String segment15;

    @Column(name = "segment16", columnDefinition = "varchar(32) comment '核算维度16'")
    private String segment16;

    @Column(name = "segment17", columnDefinition = "varchar(32) comment '核算维度17'")
    private String segment17;

    @Column(name = "segment18", columnDefinition = "varchar(32) comment '核算维度18'")
    private String segment18;

    @Column(name = "d_c", columnDefinition = "varchar(32) comment '借贷方 D/C'")
    private String dC;

    @Column(name = "debit_amt", columnDefinition = "decimal(18,8) comment '借方金额'")
    private BigDecimal debitAmt;

    @Column(name = "credit_amt", columnDefinition = "decimal(18,8) comment '贷方金额'")
    private BigDecimal creditAmt;

    @Column(name = "debit_cur_amt", columnDefinition = "decimal(18,8) comment '本币借方金额'")
    private BigDecimal debitCurAmt;

    @Column(name = "credit_cur_amt", columnDefinition = "decimal(18,8) comment '本币贷方金额'")
    private BigDecimal creditCurAmt;

    @Column(name = "curr_code", columnDefinition = "varchar(32) comment '币种'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(32) comment '币种'")
    private String currName;

    @Column(name = "exchange_rate", columnDefinition = "decimal(18,8) comment '汇率'")
    private BigDecimal exchangeRate;

    @Column(name = "gl_date", columnDefinition = "datetime(6) comment '总账日期'")
    private LocalDateTime glDate;

    @Column(name = "account_period", columnDefinition = "varchar(32) comment '会计期间'")
    private String accountPeriod;

    @Column(name = "sob_ledger_code", columnDefinition = "varchar(32) comment '账套编码'")
    private String sobLedgerCode;

    @Column(name = "sob_ledger_name", columnDefinition = "varchar(32) comment '账套名称'")
    private String sobLedgerName;
    @Column
    @Comment("业务单号")
    private String docNum1;

    @Column
    @Comment("会计引擎ID")
    private Long accountEngineId;

    @Column
    @Comment("会计引擎明细ID")
    private Long accountEngineDetailsId;

    @Column
    @Comment("记账行ID")
    private Long accEngDetDataId;

    @Column(name = "fin_abstract", columnDefinition = "varchar(200) comment '摘要'")
    private String finAbstract;

    @Column(name = "cash_flow", columnDefinition = "varchar(200) comment '现金流类型'")
    private String cashFlow;

    @Column(name = "transfer_type", columnDefinition = "varchar(100) comment '传帐类型'")
    private String transferType;

    @Column(name = "sync_status", columnDefinition = "varchar(32) comment '同步状态'")
    private String syncStatus;

    @Column(name = "sync_error", columnDefinition = "varchar(32) comment '异常原因'")
    private String syncError;

    @Column(name = "bill_no", columnDefinition = "varchar(32) comment '凭证号'")
    private String billNo;

    @Column(name = "bill_id", columnDefinition = "varchar(32) comment '主键ID'")
    private String billId;

    @Column(name = "bill_line_no", columnDefinition = "varchar(32) comment '凭证行号'")
    private String billLineNo;

    @Column(name = "bill_line_id", columnDefinition = "varchar(32) comment '行ID'")
    private String billLineId;

    @Column(name = "segment19", columnDefinition = "varchar(32) comment '核算维度19'")
    private String segment19;

    @Column(name = "segment20", columnDefinition = "varchar(32) comment '核算维度20'")
    private String segment20;

    @Column(name = "segment21", columnDefinition = "varchar(32) comment '核算维度21'")
    private String segment21;

    @Column(name = "segment22", columnDefinition = "varchar(32) comment '核算维度22'")
    private String segment22;

    @Column(name = "segment23", columnDefinition = "varchar(32) comment '核算维度23'")
    private String segment23;

    @Column(name = "segment24", columnDefinition = "varchar(32) comment '核算维度24'")
    private String segment24;

    @Column(name = "segment25", columnDefinition = "varchar(32) comment '核算维度25'")
    private String segment25;

    @Column
    @Comment("事件表单ID")
    private Long eventTableId;

    @Column
    @Comment("事件表单名称")
    private String eventTableName;

}
