package com.elitesland.fin.repo.financial;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDDTO;
import com.elitesland.fin.application.facade.param.financial.FinancialBillDPageParam;
import com.elitesland.fin.entity.financial.QFinancialBillDDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/17 14:30
 */
@Component
@RequiredArgsConstructor
public class FinancialBillDRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QFinancialBillDDO financialBillDO = QFinancialBillDDO.financialBillDDO;

    public PagingVO<FinancialBillDDTO> page(FinancialBillDPageParam financialBillDPageParam) {
        List<Predicate> where = where(financialBillDPageParam);
        JPAQuery<FinancialBillDDTO> query = select(FinancialBillDDTO.class).where(ExpressionUtils.allOf(where));
        financialBillDPageParam.setPaging(query);
        financialBillDPageParam.fillOrders(query, financialBillDO);
        return PagingVO.<FinancialBillDDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private List<Predicate> where(FinancialBillDPageParam financialBillDPageParam) {
        List<Predicate> predicates = new ArrayList<>();
        if (financialBillDPageParam.getMasId() != null) {
            predicates.add(financialBillDO.masId.eq(financialBillDPageParam.getMasId()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                financialBillDO.id,
                financialBillDO.modifyTime,
                financialBillDO.modifyUserId,
                financialBillDO.updater,
                financialBillDO.createTime,
                financialBillDO.createUserId,
                financialBillDO.remark,
                financialBillDO.deleteFlag,
                financialBillDO.tenantId,
                financialBillDO.tenantOrgId,
                financialBillDO.secBuId,
                financialBillDO.secOuId,
                financialBillDO.secUserId,
                financialBillDO.belongOrgId,
                financialBillDO.auditDataVersion,
                financialBillDO.amt,
                financialBillDO.detailActualAmount,
                financialBillDO.detailReductionAmount,
                financialBillDO.detailStandardAmount,
                financialBillDO.netAmt,
                financialBillDO.detailBillType,
                financialBillDO.masId,
                financialBillDO.taxCode
        )).from(financialBillDO);
    }

}
