package com.elitesland.fin.utils;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.jpa.util.DatabaseDialectDetector;
import com.elitesland.fin.common.PartitionQueryParam;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.impl.JPAQuery;

import javax.validation.constraints.NotNull;

/**
 * PG数据库分区字段处理工具
 */
public class PartitionJpaUtil {
    private static DatabaseDialectDetector databaseDialectDetector;

    public static void appendYmConditionToPredicate(JPAQuery jpaQuery, @NotNull Class<?> entityClass, @NotNull PartitionQueryParam param) {
        if (param.getYmTo() == null && param.getYmFrom() == null) {
            return;
        }
        if (databaseDialectDetector == null) {
            databaseDialectDetector = SpringContextHolder.getBean(DatabaseDialectDetector.class);
        }
        if (databaseDialectDetector.isMySQLDialect()) {
            return;
        }
        String entityName = entityClass.getSimpleName();
        String var10000 = entityName.substring(0, 1).toLowerCase();
        String alias = var10000 + entityName.substring(1);
        PathBuilder<?> entityPath = new PathBuilder(entityClass, alias);
        NumberPath<Integer> path = entityPath.getNumber("ym", Integer.class);
        if (param.getYmFrom().equals(param.getYmTo())) {
            jpaQuery.where(path.eq(param.getYmFrom()));
        } else {
            jpaQuery.where(path.between(param.getYmFrom(), param.getYmTo()));
        }
    }
}
