/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.account;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.TcStatementAccountConvert;
import com.elitesland.fin.application.facade.vo.account.TcStatementAccountVO;
import com.elitesland.fin.application.service.account.TcStatementAccountService;
import com.elitesland.fin.entity.account.TcStatementAccountDO;
import com.elitesland.fin.infinity.utils.CsvReadListener;
import com.elitesland.fin.infinity.utils.CsvReaderUtil;
import com.elitesland.fin.infinity.utils.SshConnectionManager;
import com.elitesland.fin.param.account.TcStatementAccountPageParam;
import com.elitesland.fin.repo.account.TcStatementAccountRepo;
import com.elitesland.fin.repo.account.TcStatementAccountRepoProc;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TcStatementAccountServiceImpl
implements TcStatementAccountService {
    private static final Logger log = LoggerFactory.getLogger(TcStatementAccountServiceImpl.class);
    private final TcStatementAccountRepo tcStatementAccountRepo;
    private final TcStatementAccountRepoProc tcStatementAccountRepoProc;
    private final OrgStoreRpcService orgStoreRpcService;

    @Override
    @SysCodeProc
    public PagingVO<TcStatementAccountVO> page(TcStatementAccountPageParam pageParam) {
        PagingVO<TcStatementAccountDO> result = this.tcStatementAccountRepoProc.page(pageParam);
        PagingVO resultVO = result.map(TcStatementAccountConvert.INSTANCE::doToVO);
        return resultVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sync(String fileName) throws IOException {
        if (fileName == null) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u6587\u4ef6");
        }
        final ArrayList<TcStatementAccountVO> tcStatementAccountVOS = new ArrayList<TcStatementAccountVO>();
        SFTPClient sftp = SshConnectionManager.getSshVo().getSftp();
        File tempFile = Files.createTempFile("sftp-", ".tmp", new FileAttribute[0]).toFile();
        List files = sftp.ls("/nongxiaoguo/nongxiaoguo");
        String path = null;
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            List targetFiles = files.stream().filter(v -> v.getName().contains(fileName)).collect(Collectors.toList());
            path = ((RemoteResourceInfo)targetFiles.get(targetFiles.size() - 1)).getPath();
        }
        if (path == null) {
            throw new BusinessException("\u672a\u627e\u5230\u6587\u4ef6");
        }
        sftp.get(path, (LocalDestFile)new FileSystemFile(tempFile));
        CsvReaderUtil.readCsv(tempFile.getPath(), TcStatementAccountVO.class, new CsvReadListener<TcStatementAccountVO>(){
            private int count = 0;

            @Override
            public void invoke(TcStatementAccountVO data) {
                ++this.count;
                log.info("\u8bfb\u53d6\u5230\u6570\u636e: " + data);
                tcStatementAccountVOS.add(data);
            }

            @Override
            public void doAfterAllAnalysed() {
                log.info("CSV\u6587\u4ef6\u8bfb\u53d6\u5b8c\u6210\uff0c\u5171\u8bfb\u53d6 " + this.count + " \u6761\u6570\u636e");
            }
        });
        OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
        orgStoreBaseRpcParam.setStoreCodeList(tcStatementAccountVOS.stream().map(TcStatementAccountVO::getStoreCode).collect(Collectors.toList()));
        Map<String, OrgStoreBaseRpcDTO> storeMap = ((List)this.orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam).computeData()).stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, v -> v));
        tcStatementAccountVOS.forEach(t -> {
            if (storeMap.containsKey(t.getStoreCode())) {
                t.setStoreBusinessType(((OrgStoreBaseRpcDTO)storeMap.get(t.getStoreCode())).getStoreType2());
            }
        });
        this.tcStatementAccountRepo.saveAll(TcStatementAccountConvert.INSTANCE.voListToDOList(tcStatementAccountVOS));
    }

    public TcStatementAccountServiceImpl(TcStatementAccountRepo tcStatementAccountRepo, TcStatementAccountRepoProc tcStatementAccountRepoProc, OrgStoreRpcService orgStoreRpcService) {
        this.tcStatementAccountRepo = tcStatementAccountRepo;
        this.tcStatementAccountRepoProc = tcStatementAccountRepoProc;
        this.orgStoreRpcService = orgStoreRpcService;
    }
}

