package com.elitesland.fin.application.facade.param.arorder;

import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author lucan.liu
 * @date 2023-09-08 12:25
 */
@Data
public class ArOrderExPageParam extends ArOrderPageParam {

    private static final long serialVersionUID = -7495283385561765565L;

    @ApiModelProperty("应收单号")
    private String arOrderNo;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("主客户编码")
    private String custCode;

    @ApiModelProperty("金额 开始")
    private BigDecimal totalAmtStart;

    @ApiModelProperty("金额 结束")
    private BigDecimal totalAmtEnd;

    @ApiModelProperty("部门编码")
    private String buCode;

    @ApiModelProperty("业务员编码")
    private String businessCode;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("开票类型")
    private String invType;

    @ApiModelProperty("核销状态")
    private String verState;

    @ApiModelProperty("创建开始日期")
    private LocalDateTime createTimeStart;

    @ApiModelProperty("创建结束日期")
    private LocalDateTime createTimeEnd;

    @ApiModelProperty("开票备注")
    private String remark;

    @ApiModelProperty("发票号码")
    private String invoiceNumber;

    @ApiModelProperty("开票日期开始")
    private LocalDateTime invStartDate;

    @ApiModelProperty("开票日期结束")
    private LocalDateTime invEndDate;

    @ApiModelProperty("第三方应收单号")
    private String sourceNo;

    @ApiModelProperty("红冲标志")
    private Boolean redFlushSign;

    @ApiModelProperty("期初标志")
    private Boolean initFlag;

    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty("核销状态")
    private List<String> verStateList;

    @ApiModelProperty("ids")
    private List<Long> ids;

    @ApiModelProperty(value = "表头标识符")
    private Boolean headFlag;
}
