package com.elitesland.fin.common;


import com.elitesland.fin.constant.FinBusinessObjectConstant;

/**
 * @author : chen.niu
 * @description : 财务业务对象类型枚举
 * @date : 2023-12-01 16:26
 */
public enum FinBusinessObjectEnum implements FinBusinessObjectConstant {


    FinCommon(FinBusinessObjectConstant.FIN_COMMON),
    FinAdjust(FinBusinessObjectConstant.FIN_ADJUST),
    FinAdjustTo(FinBusinessObjectConstant.FIN_ADJUST_TO),
    FinLimitAdjust(FinBusinessObjectConstant.FIN_LIMIT_ADJUST),
    TC_STATEMENT_ACCOUNT(FinBusinessObjectConstant.TC_STATEMENT_ACCOUNT),
    TEST("测试");



    private final String description;

    FinBusinessObjectEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }


}
