package com.elitesland.fin.entity.invoice;

import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Entity
@Table(name = "fin_payment_notice")
@org.hibernate.annotations.Table(appliesTo = "fin_payment_notice", comment = "付款通知表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "付款通知表", description = "付款通知表")
@Where(clause = "delete_flag = 0")
public class PaymentNoticeDO extends BaseModel implements Serializable {

    /**
     * 加盟商ID
     */
    @Column(name = "franchisee_id", columnDefinition = "bigint(20) comment '加盟商ID'")
    private String franchiseeId;
    /**
     * 公司ID
     */
    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;
    /**
     * 公司编码
     */
    @Column(name = "ou_code", columnDefinition = "varchar(40) comment '公司编码'")
    private String ouCode;
    /**
     * 公司名称
     */
    @Column(name = "ou_name", columnDefinition = "varchar(255) comment '公司名称'")
    private String ouName;
    /**
     * 开户银行
     */
    @Column(name = "inv_bank_no", columnDefinition = "varchar(100) comment '开户银行'")
    private String invBankNo;
    /**
     * 银行账号
     */
    @Column(name = "bank_account", columnDefinition = "varchar(100) comment '银行账号'")
    private String bankAccount;
    /**
     * 收费项目
     */
    @Column(name = "item_code", columnDefinition = "varchar(40) comment '收费项目'")
    private String itemCode;
    /**
     * 税率
     */
    @Column(name = "tax_rate", columnDefinition = "DECIMAL(20,6) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "amt", columnDefinition = "DECIMAL(20,6) comment '含税金额'")
    private BigDecimal amt;

    /**
     * 日期
     */
    @Column(name = "notice_date", columnDefinition = "dateTime comment '日期'")
    private LocalDate noticeDate;
    /**
     * 通知内容
     */
    @Column(name = "notice_content", columnDefinition = "varchar(255) comment '通知内容'")
    private String noticeContent;

    @Column(name = "uni_bank_no", columnDefinition = "varchar(125) comment '联行号'")
    private String uniBankNo;
    @Column(name = "amtRate", columnDefinition = "DECIMAL(20,6) comment '可开票金额'")
    private BigDecimal amtRate;

    @Column(name = "store_code", columnDefinition = "varchar(32) comment '门店编码'")
    private String storeCode;

    @Column(name = "store_name", columnDefinition = "varchar(255) comment '门店名称'")
    private String storeName;

}
