/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookLineConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookLineDTO;
import com.elitesland.fin.application.service.accountingengine.FinSetOfBookLineService;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookLineDO;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookLineRepo;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FinSetOfBookLineServiceImpl
implements FinSetOfBookLineService {
    private static final Logger log = LoggerFactory.getLogger(FinSetOfBookLineServiceImpl.class);
    private final FinSetOfBookLineRepo finSetOfBookLineRepo;

    @Override
    public List<FinSetOfBookLineDTO> findByMasId(long masId) {
        List<FinSetOfBookLineDO> finSetOfBookLineDOS = this.finSetOfBookLineRepo.findAllByMasId(masId);
        if (CollectionUtils.isEmpty(finSetOfBookLineDOS)) {
            return null;
        }
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOS = FinSetOfBookLineConvert.INSTANCE.DOToDTO(finSetOfBookLineDOS);
        return finSetOfBookLineDTOS;
    }

    @Override
    public List<FinSetOfBookLineDTO> findByMasIds(List<Long> masIds) {
        List<FinSetOfBookLineDO> finSetOfBookLineDOS = this.finSetOfBookLineRepo.findAllByMasIdIn(masIds);
        if (CollectionUtils.isEmpty(finSetOfBookLineDOS)) {
            return null;
        }
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOS = FinSetOfBookLineConvert.INSTANCE.DOToDTO(finSetOfBookLineDOS);
        return finSetOfBookLineDTOS;
    }

    public FinSetOfBookLineServiceImpl(FinSetOfBookLineRepo finSetOfBookLineRepo) {
        this.finSetOfBookLineRepo = finSetOfBookLineRepo;
    }
}

