package com.elitesland.fin.application.facade.param.financial;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 充值单;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-2-20
 */
@Data
@ApiModel(description = "账单")
public class ManagementFeeBillPageParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -5534428658178696764L;

    @ApiModelProperty("主键ID")
    private List<Long> idList;

    @ApiModelProperty("账户号")
    private String accountNo;
    private List<String> accountNoList;

    @ApiModelProperty("记账日期 (格式: yyyy-MM-dd HH:mm:ss)")
    private String accountTime;

    @ApiModelProperty("收支类型")
    private String dcType;

    @ApiModelProperty("收支编码")
    private String dcCode;

    @ApiModelProperty("收支名称")
    private String dcName;

    @ApiModelProperty("账户类型")
    private String accountType;

    @ApiModelProperty("平台流水号")
    private String bussNo;
    private List<String> bussNoList;

    @ApiModelProperty("云资金流水号")
    private String slBussNo;

    @ApiModelProperty("外部业务单号")
    private String outBussNo;

    @ApiModelProperty("付方档案编码 (三方的门店或公司)")
    private String payArchiveCode;

    @ApiModelProperty("付方档案名称")
    private String payArchiveName;

    @ApiModelProperty("付方银行")
    private String payBank;

    @ApiModelProperty(value = "付款方账户号")
    private String paymentAccountNo;

    @ApiModelProperty(value = "付款方账户名称")
    private String paymentAccountName;

    @ApiModelProperty(value = "收款方账户号")
    private String payeeAccountNo;

    @ApiModelProperty(value = "收款方账户名称")
    private String payeeAccountName;

    @ApiModelProperty("收方档案编码 (三方的门店或公司)")
    private String payeeArchiveCode;

    @ApiModelProperty("收方档案名称")
    private String payeeArchiveName;

    @ApiModelProperty("收方银行")
    private String payeeBank;

    @ApiModelProperty("传账状态")
    private String transferStatus;

    @ApiModelProperty("拟定状态")
    private String proposedStatus;

    @ApiModelProperty("分页标识(N不分页)")
    private String pageFlag;

}