package com.elitesland.fin.application.service.creditaccountflow;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowPageParam;
import java.util.List;

/**
 * @Author gyj
 * @Date 2023/02/25
 */
public interface CreditAccountFlowService {

    PagingVO<CreditAccountFlowDTO> page(CreditAccountFlowPageParam creditAccountFlowPageParam);

    PagingVO<CreditAccountFlowDTO> appPage(CreditAccountFlowPageParam creditAccountFlowPageParam);

    void approve(CreditAccountFlowParam creditAccountFlowParam);

    void reject(CreditAccountFlowParam creditAccountFlowParam);

    void accountFlowCallBack(String doc, CreditAccountFlowDO creditAccountFlowDO, boolean isApprove);

    String generateCreditAccountFlow(CreditAccountFlowParam creditAccountFlowParam);

    /**
     * 校验信用账户余额
     */
    Boolean checkCreditAccountBalance(CreditAccountFlowParam creditAccountFlowParam);

    List<CreditAccountFlowVO> selectListByQueryParam(CreditAccountFlowParam queryParam);

    List<CreditAccountFlowVO> selectRepairAfterPage(CreditAccountFlowPageParam pageParam);

    List<CreditAccountFlowVO> selectRepairAfter(CreditAccountFlowParam pageParam);

    public void updateBalanceAndGenerateCreditAccountFlow(List<CreditAccountFlowParam> creditAccountFlowParams);

    public void saveCreditAccountFlowList(List<CreditAccountFlowParam> creditAccountFlowParams);

    /**
     * 删除信用账户流水
     */
    void updateDeleteFlagBatch(List<Long> ids);
}
