package com.elitesland.fin.entity.invoice;

import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/11
 */
@Entity
@Table(name = "invoice_rule_config")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "invoice_rule_config", comment = "开票规则配置")
@Data
@Accessors(chain = true)
@ApiModel(value = "invoice_rule_config", description = "开票规则配置")
public class InvoiceRuleConfigDO extends BaseModel implements Serializable {

    @ApiModelProperty("来源单据名称 [UDC]yst-supp:DOC_CLS")
    @Column(name = "opt_doc_cli", columnDefinition = "varchar(32)  comment '适用单据 [UDC]yst-supp:DOC_CLS'")
    private String optDocCls;

    @ApiModelProperty("来源单据类型 [UDC]yst-supp:DOC_TYPE")
    @Column(name = "opt_doc_type", columnDefinition = "varchar(32)  comment '来源单据类型'")
    private String optDocType;

    @ApiModelProperty("可开票单据状态 [UDC]yst-franchisee:PAYMENT_STATUS")
    @Column(name = "opt_doc_status", columnDefinition = "varchar(32)  comment '可开票单据状态'")
    private String optDocStatus;

    @ApiModelProperty("可开票时限（天）")
    @Column(name = "invoice_limit", columnDefinition = "int(11)  comment '可开票时限（天）'")
    private Integer invoiceLimit;

    @ApiModelProperty(value = "是否自动开票 1-是 0-否")
    @Column(name = "auto_invoice",columnDefinition = "int(11) DEFAULT '0' comment '是否自动开票 1-是 0-否'")
    private Integer autoInvoice;

    @ApiModelProperty(value = "是否自动审核 1-是 0-否")
    @Column(name = "auto_review",columnDefinition = "int(11) DEFAULT '0' comment '流水自动审核 1-是 0-否'")
    private Integer autoReview;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    @Column(name = "status", columnDefinition = "varchar(32) default 'ACTIVE'  comment '是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS'")
    private String status;

    @ApiModelProperty(value = "发票红冲前是否需要换开申请审核 1-是 0-否")
    @Column(name = "need_redraft",columnDefinition = "int(11) DEFAULT '0' comment '发票红冲前是否需要换开申请审核 1-是 0-否'")
    private Integer needRedraft;

    @ApiModelProperty(value = "是否允许修改发票抬头 1-是 0-否")
    @Column(name = "edit_inv_title",columnDefinition = "int(11) DEFAULT '0' comment '是否允许修改发票抬头 1-是 0-否'")
    private Integer editInvTitle;

    @ApiModelProperty(value = "公司名称")
    @Column(name = "ou_name",columnDefinition = "varchar(64)")
    private String ouName;

    @ApiModelProperty(value = "公司编码")
    @Column(name = "ou_code",columnDefinition = "varchar(32)")
    private String ouCode;
}
