package com.elitesland.fin.repo.financial;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.financial.ManagementFeeBillDTO;
import com.elitesland.fin.application.facade.param.financial.ManagementFeeBillPageParam;
import com.elitesland.fin.entity.financial.QManagementFeeBillDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/17 14:30
 */
@Component
@RequiredArgsConstructor
public class ManagementFeeBillRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QManagementFeeBillDO managementFeeBillDO = QManagementFeeBillDO.managementFeeBillDO;

    public PagingVO<ManagementFeeBillDTO> page(ManagementFeeBillPageParam param) {
        List<Predicate> where = where(param);
        JPAQuery<ManagementFeeBillDTO> query = select(ManagementFeeBillDTO.class).where(ExpressionUtils.allOf(where));
        param.setPaging(query);
        param.fillOrders(query, managementFeeBillDO);
        return PagingVO.<ManagementFeeBillDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<ManagementFeeBillDTO> billList(ManagementFeeBillPageParam param) {
        List<Predicate> where = where(param);
        JPAQuery<ManagementFeeBillDTO> query = select(ManagementFeeBillDTO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(ManagementFeeBillPageParam param) {
        List<Predicate> predicates = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(param.getIdList())) {
            predicates.add(managementFeeBillDO.id.in(param.getIdList()));
        }
        if (StringUtils.isNotEmpty(param.getAccountNo())) {
            predicates.add(managementFeeBillDO.accountNo.eq(param.getAccountNo()));
        }
        if (CollectionUtils.isNotEmpty(param.getAccountNoList())) {
            predicates.add(managementFeeBillDO.accountNo.in(param.getAccountNoList()));
        }
        if (StringUtils.isNotEmpty(param.getAccountTime())) {
            predicates.add(managementFeeBillDO.accountTime.gt(param.getAccountTime()));
        }
        if (StringUtils.isNotEmpty(param.getDcType())) {
            predicates.add(managementFeeBillDO.dcType.eq(param.getDcType()));
        }
        if (StringUtils.isNotEmpty(param.getDcCode())) {
            predicates.add(managementFeeBillDO.dcCode.eq(param.getDcCode()));
        }
        if (StringUtils.isNotEmpty(param.getDcName())) {
            predicates.add(managementFeeBillDO.dcName.eq(param.getDcName()));
        }
        if (StringUtils.isNotEmpty(param.getAccountType())) {
            predicates.add(managementFeeBillDO.accountType.eq(param.getAccountType()));
        }
        if (StringUtils.isNotEmpty(param.getBussNo())) {
            predicates.add(managementFeeBillDO.bussNo.eq(param.getBussNo()));
        }
        if (CollectionUtils.isNotEmpty(param.getBussNoList())) {
            predicates.add(managementFeeBillDO.bussNo.in(param.getBussNoList()));
        }
        if (StringUtils.isNotEmpty(param.getSlBussNo())) {
            predicates.add(managementFeeBillDO.slBussNo.eq(param.getSlBussNo()));
        }
        if (StringUtils.isNotEmpty(param.getOutBussNo())) {
            predicates.add(managementFeeBillDO.outBussNo.eq(param.getOutBussNo()));
        }
        if (StringUtils.isNotEmpty(param.getPaymentAccountNo())) {
            predicates.add(managementFeeBillDO.paymentAccountNo.eq(param.getPaymentAccountNo()));
        }
        if (StringUtils.isNotEmpty(param.getPayeeAccountNo())) {
            predicates.add(managementFeeBillDO.payeeAccountNo.eq(param.getPayeeAccountNo()));
        }
        if (StringUtils.isNotEmpty(param.getProposedStatus())) {
            predicates.add(managementFeeBillDO.proposedStatus.eq(param.getProposedStatus()));
        }
        if (StringUtils.isNotEmpty(param.getTransferStatus())) {
            predicates.add(managementFeeBillDO.transferStatus.eq(param.getTransferStatus()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                managementFeeBillDO.id,
                managementFeeBillDO.modifyTime,
                managementFeeBillDO.modifyUserId,
                managementFeeBillDO.updater,
                managementFeeBillDO.createTime,
                managementFeeBillDO.createUserId,
                managementFeeBillDO.remark,
                managementFeeBillDO.deleteFlag,
                managementFeeBillDO.tenantId,
                managementFeeBillDO.tenantOrgId,
                managementFeeBillDO.secBuId,
                managementFeeBillDO.secOuId,
                managementFeeBillDO.secUserId,
                managementFeeBillDO.belongOrgId,
                managementFeeBillDO.auditDataVersion,
                managementFeeBillDO.accountNo,
                managementFeeBillDO.accountTime,
                managementFeeBillDO.dcType,
                managementFeeBillDO.dcCode,
                managementFeeBillDO.dcName,
                managementFeeBillDO.accountType,
                managementFeeBillDO.bussNo,
                managementFeeBillDO.slBussNo,
                managementFeeBillDO.outBussNo,
                managementFeeBillDO.payArchiveCode,
                managementFeeBillDO.payArchiveName,
                managementFeeBillDO.payBank,
                managementFeeBillDO.paymentAccountNo,
                managementFeeBillDO.paymentAccountName,
                managementFeeBillDO.payeeAccountNo,
                managementFeeBillDO.payeeAccountName,
                managementFeeBillDO.payeeArchiveCode,
                managementFeeBillDO.payeeArchiveName,
                managementFeeBillDO.payeeBank,
                managementFeeBillDO.incomeAmount,
                managementFeeBillDO.amount,
                managementFeeBillDO.fee,
                managementFeeBillDO.postscript,
                managementFeeBillDO.remark,
                managementFeeBillDO.proposedStatus,
                managementFeeBillDO.transferStatus
        )).from(managementFeeBillDO);
    }

}
