//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.elitesland.fin.utils.tcsl.service;

import com.elitesland.fin.utils.tcsl.utils.RSA;
import com.elitesland.fin.utils.tcsl.utils.SignType;

import java.util.*;

public class SignManager implements ISignManager {
    protected String signType;
    protected String md5PrivateKey;
    protected String rsaPrivateKey;
    protected String hmacsha256PrivateKey;
    protected String inputCharset;
    protected String signName;
    protected String signTypeName;

    public SignManager() {
        this.signType = SignType.RSA;
        this.inputCharset = "utf-8";
        this.signName = "sign";
        this.signTypeName = "sign_type";
    }

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getMd5PrivateKey() {
        return this.md5PrivateKey;
    }

    public void setMd5PrivateKey(String md5PrivateKey) {
        this.md5PrivateKey = md5PrivateKey;
    }

    public String getRsaPrivateKey() {
        return this.rsaPrivateKey;
    }

    public void setRsaPrivateKey(String rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public String getInputCharset() {
        return this.inputCharset;
    }

    public void setInputCharset(String inputCharset) {
        this.inputCharset = inputCharset;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getSignTypeName() {
        return this.signTypeName;
    }

    public void setSignTypeName(String signTypeName) {
        this.signTypeName = signTypeName;
    }

    public String getHmacsha256PrivateKey() {
        return this.hmacsha256PrivateKey;
    }

    public void setHmacsha256PrivateKey(String hmacsha256PrivateKey) {
        this.hmacsha256PrivateKey = hmacsha256PrivateKey;
    }

    public Map<String, Object> buildRequestPara(Map<String, Object> sParaTemp) {
        Map<String, Object> sPara = this.paraFilter(sParaTemp);
        String mysign = this.buildRequestMysign(sPara);
        sPara.put(this.signName, mysign);
        sPara.put(this.signTypeName, this.signType);
        return sPara;
    }

    private String buildRequestMysign(Map<String, Object> sPara) {
        String prestr = this.createLinkString(sPara);
        String mysign = "";
        if (this.signType.equals(SignType.MD5)) {
            mysign = RSA.sign(prestr, this.md5PrivateKey, this.inputCharset);
        } else if (this.signType.equals(SignType.RSA)) {
            mysign = RSA.sign(prestr, this.rsaPrivateKey, this.inputCharset);
        } else if (this.signType.equals(SignType.HMACSHA256)) {
            mysign = RSA.getSignHmacSHA256(sPara, this.hmacsha256PrivateKey);
        }

        return mysign;
    }

    protected Map<String, Object> paraFilter(Map<String, Object> sArray) {
        Map<String, Object> result = new HashMap();
        if (sArray != null && sArray.size() > 0) {
            Iterator var3 = sArray.keySet().iterator();

            while(var3.hasNext()) {
                String key = (String)var3.next();
                Object value = sArray.get(key);
                if (value != null && !value.equals("") && !key.equalsIgnoreCase(this.signName) && !key.equalsIgnoreCase(this.signTypeName)) {
                    result.put(key, value);
                }
            }

            return result;
        } else {
            return result;
        }
    }

    public String createLinkString(Map<String, Object> params) {
        List<String> keys = new ArrayList(params.keySet());
        Collections.sort(keys);
        String prestr = "";

        for(int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Object value = params.get(key);
            if (i == keys.size() - 1) {
                prestr = prestr + key + "=" + value;
            } else {
                prestr = prestr + key + "=" + value + "&";
            }
        }

        return prestr;
    }
}
