package com.elitesland.fin.utils.tcsl.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
@ApiModel("天才商龙返回值")
public class TcslDataResponse implements Serializable {
    private static final long serialVersionUID = 6074350548106028859L;

    @ApiModelProperty("业务侧返回状态 1-成功 -1-失败")
    private Integer returnCode;

    @ApiModelProperty("错误代码 200-成功，其他失败")
    private String errorCode;

    @ApiModelProperty("错误信息")
    private String errorText;

    @ApiModelProperty("失败原因")
    private String errMsg;

    @ApiModelProperty("业务返回数据")
    private TcslDataRecordResponse data;
    public boolean isSuccess(){
        return StringUtils.isNotEmpty(errorCode) && "200".equals(errorCode);
    }
}
