package com.elitesland.fin.utils.tcsl.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
@ApiModel("天才商龙返回值")
public class TcslResponse implements Serializable {
    private static final long serialVersionUID = 6074350548106028859L;

    @ApiModelProperty("处理结果标识：0-成功，其他-失败")
    private String code;

    @ApiModelProperty("返回信息")
    private String msg;

    @ApiModelProperty("返回数据")
    private TcslDataResponse data;

    @ApiModelProperty("请求唯一标识，有用户请求时传参")
    private String traceId;

    public boolean isSuccess(){
        return StringUtils.isNotEmpty(code) && "0".equals(code);
    }
}
