/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.financial;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.financial.ManagementFeeBillConvert;
import com.elitesland.fin.application.facade.dto.financial.ManagementFeeBillDTO;
import com.elitesland.fin.application.facade.param.financial.ManagementFeeBillPageParam;
import com.elitesland.fin.application.facade.vo.financial.ManagementFeeBillVO;
import com.elitesland.fin.application.service.financial.ManagementFeeBillService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.financial.ManagementFeeBillDO;
import com.elitesland.fin.repo.financial.ManagementFeeBillRepo;
import com.elitesland.fin.repo.financial.ManagementFeeBillRepoProc;
import com.elitesland.fin.utils.tcsl.utils.TcslApiClient;
import com.elitesland.fin.utils.tcsl.vo.BillQueryParamVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ManagementFeeBillServiceImpl
implements ManagementFeeBillService {
    private static final Logger log = LoggerFactory.getLogger(ManagementFeeBillServiceImpl.class);
    private final TcslApiClient tcslApiClient;
    private final ManagementFeeBillRepo managementFeeBillRepo;
    private final ManagementFeeBillRepoProc managementFeeBillRepoProc;
    private final UdcProvider udcProvider;

    @Override
    @SysCodeProc
    public PagingVO<ManagementFeeBillVO> pageSearch(ManagementFeeBillPageParam param) {
        return ManagementFeeBillConvert.INSTANCE.convertPage(this.managementFeeBillRepoProc.page(param));
    }

    @Override
    public void syncBill(String param) {
        BillQueryParamVO paramVO = new BillQueryParamVO();
        if (StringUtils.isNotEmpty((CharSequence)param)) {
            String[] split = param.split(";");
            if (split.length != 2) {
                throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
            }
            paramVO.setStartTime(split[0]);
            paramVO.setEndTime(split[1]);
        }
        Map syncStatusMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "DC_CODE_TYPE");
        ArrayList<String> dcCodeList = new ArrayList<String>(syncStatusMap.keySet());
        paramVO.setDcCodeList(dcCodeList);
        Integer pageNo = 1;
        Integer pageSize = 100;
        ArrayList<ManagementFeeBillDTO> billDTOList = new ArrayList();
        do {
            paramVO.setPageNo(pageNo);
            paramVO.setPageSize(pageSize);
            billDTOList = this.tcslApiClient.queryBill(paramVO);
            if (CollectionUtils.isNotEmpty(billDTOList)) {
                List<ManagementFeeBillDO> billDOList = ManagementFeeBillConvert.INSTANCE.dtoToDo(billDTOList);
                List<String> bussNoList = billDOList.stream().map(ManagementFeeBillDO::getBussNo).toList();
                List<String> accountNoList = billDOList.stream().map(ManagementFeeBillDO::getAccountNo).toList();
                ManagementFeeBillPageParam pageParam = new ManagementFeeBillPageParam();
                pageParam.setAccountNoList(accountNoList);
                pageParam.setBussNoList(bussNoList);
                pageParam.setPageFlag("N");
                List<ManagementFeeBillDTO> existList = this.managementFeeBillRepoProc.billList(pageParam);
                List<Object> keys = new ArrayList();
                if (CollectionUtils.isNotEmpty(existList)) {
                    keys = existList.stream().map(t -> t.getAccountNo() + "-" + t.getBussNo()).toList();
                }
                log.info("\u5df2\u5b58\u5728\u7ba1\u7406\u8d39\u8d26\u5355\uff1a{}", keys);
                ArrayList saveDOList = new ArrayList();
                List<Object> finalKeys = keys;
                billDOList.forEach(billDO -> {
                    if (!finalKeys.contains(billDO.getAccountNo() + "-" + billDO.getBussNo())) {
                        billDO.setTransferStatus(UdcEnum.AP_TRANSFER_STATUS_WAIT.getValueCode());
                        billDO.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
                        saveDOList.add(billDO);
                    }
                });
                if (CollectionUtils.isNotEmpty(saveDOList)) {
                    this.managementFeeBillRepo.saveAll(saveDOList);
                }
            }
            Integer n = pageNo;
            pageNo = pageNo + 1;
        } while (CollectionUtils.isNotEmpty(billDTOList));
    }

    public ManagementFeeBillServiceImpl(TcslApiClient tcslApiClient, ManagementFeeBillRepo managementFeeBillRepo, ManagementFeeBillRepoProc managementFeeBillRepoProc, UdcProvider udcProvider) {
        this.tcslApiClient = tcslApiClient;
        this.managementFeeBillRepo = managementFeeBillRepo;
        this.managementFeeBillRepoProc = managementFeeBillRepoProc;
        this.udcProvider = udcProvider;
    }
}

