/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.rectype;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.entity.rectype.QRecTypeOuDO;
import com.elitesland.fin.domain.param.rectype.RecTypeOuPageParam;
import com.elitesland.fin.infr.dto.rectype.RecTypeOuDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class RecTypeOuRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QRecTypeOuDO qRecTypeOuDO = QRecTypeOuDO.recTypeOuDO;

    public List<Long> queryByOuId(Long ouId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qRecTypeOuDO.recTypeId).from((EntityPath)this.qRecTypeOuDO)).where((Predicate)this.qRecTypeOuDO.ouId.eq((Object)ouId))).fetch();
    }

    public List<RecTypeOuDTO> queryByRecTypeIds(List<Long> recTypeIds) {
        return ((JPAQuery)this.select(RecTypeOuDTO.class).where((Predicate)this.qRecTypeOuDO.recTypeId.in(recTypeIds))).fetch();
    }

    public void deleteByIds(List<Long> ids) {
        this.jpaQueryFactory.delete((EntityPath)this.qRecTypeOuDO).where(new Predicate[]{this.qRecTypeOuDO.id.in(ids)}).execute();
    }

    public PagingVO<RecTypeOuDTO> page(RecTypeOuPageParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (param.getRecTypeId() != null) {
            predicates.add(this.qRecTypeOuDO.recTypeId.eq((Object)param.getRecTypeId()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getOuNameOrCode())) {
            predicates.add(this.qRecTypeOuDO.ouName.like("%" + param.getOuNameOrCode() + "%").or((Predicate)this.qRecTypeOuDO.ouCode.like("%" + param.getOuNameOrCode() + "%")));
        }
        JPAQuery query = (JPAQuery)this.select(RecTypeOuDTO.class).where(ExpressionUtils.allOf(predicates));
        param.setPaging(query);
        param.fillOrders(query, this.qRecTypeOuDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qRecTypeOuDO.id, this.qRecTypeOuDO.recTypeId, this.qRecTypeOuDO.ouId, this.qRecTypeOuDO.ouCode, this.qRecTypeOuDO.ouName, this.qRecTypeOuDO.ouType})).from((EntityPath)this.qRecTypeOuDO);
    }

    public RecTypeOuRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

