/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.utils.tcsl.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.shaded.com.google.gson.Gson;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitesland.fin.application.convert.financial.ManagementFeeBillConvert;
import com.elitesland.fin.application.facade.dto.financial.ManagementFeeBillDTO;
import com.elitesland.fin.utils.tcsl.config.LakalaProperties;
import com.elitesland.fin.utils.tcsl.utils.ThirdSysLogUtil;
import com.elitesland.fin.utils.tcsl.vo.BillQueryParamVO;
import com.elitesland.fin.utils.tcsl.vo.SyncResult;
import com.elitesland.fin.utils.tcsl.vo.TcslDataRecordResponse;
import com.elitesland.fin.utils.tcsl.vo.TcslResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
public class TcslApiClient {
    private static final Logger log = LoggerFactory.getLogger(TcslApiClient.class);
    private final String TCSL_THIRD_APP = "TSCL";
    private final String TCSL_BUSINESS_CODE = "TCSL_ACCOUNT_BILL";
    private final LakalaProperties lakalaProperties;

    public List<ManagementFeeBillDTO> queryBill(BillQueryParamVO paramVO) {
        SyncResult send;
        LocalDateTime localDateTime;
        paramVO.setBrandId(this.lakalaProperties.getBrandId());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isEmpty((CharSequence)paramVO.getStartTime())) {
            localDateTime = LocalDateTime.now().minusDays(1L).withHour(0).withMinute(0).withSecond(0);
            paramVO.setStartTime(localDateTime.format(dateTimeFormatter));
        }
        if (StringUtils.isEmpty((CharSequence)paramVO.getEndTime())) {
            localDateTime = LocalDateTime.now().withHour(0).withMinute(0).withSecond(0);
            paramVO.setEndTime(localDateTime.format(dateTimeFormatter));
        }
        if ((send = this.send(JSONObject.toJSONString((Object)paramVO), this.lakalaProperties.getBillQuery())).getSuccess() != null && !send.getSuccess().booleanValue()) {
            throw new BusinessException("\u8d26\u5355\u67e5\u8be2\u5f02\u5e38\uff1a" + send.getReqFailMsg());
        }
        TcslResponse response = (TcslResponse)new Gson().fromJson(send.getData(), TcslResponse.class);
        TcslDataRecordResponse data = response.getData().getData();
        return ManagementFeeBillConvert.INSTANCE.dataToDTO(data.getRecords());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncResult send(String params, String methodName) {
        SyncResult syncResult = null;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("groupID", this.lakalaProperties.getGroupID());
        headerMap.put("traceID", UUID.randomUUID().toString());
        headerMap.put("Proxy-Client-IP", "192.168.28.30");
        HashMap<String, String> systemParamsMap = new HashMap<String, String>();
        systemParamsMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        systemParamsMap.put("appKey", this.lakalaProperties.getAppKey());
        systemParamsMap.put("version", "1");
        systemParamsMap.put("charset", "UTF-8");
        HashMap<String, String> bizParamsMap = new HashMap<String, String>();
        bizParamsMap.put("biz", params);
        try {
            String urlForGenSig = this.genUrlForGenSig(this.lakalaProperties.getHost(), methodName, systemParamsMap, bizParamsMap);
            log.info("\u5b8c\u6574url\u8def\u5f84: " + urlForGenSig);
            String sig = this.getSig(this.lakalaProperties.getAppSecret(), urlForGenSig);
            log.info("Request Body : " + JSONObject.toJSONString((Object)params));
            String result = this.sendRequest(urlForGenSig, sig, headerMap, bizParamsMap);
            log.info("Response Body : " + result);
            TcslResponse response = (TcslResponse)JSON.parseObject((String)result, TcslResponse.class);
            syncResult = response.isSuccess() && response.getData() != null && response.getData().isSuccess() ? SyncResult.success(params, result, HttpMethod.POST, this.lakalaProperties.getHost(), methodName, true, "TSCL", null) : SyncResult.fail(params, result, false, response.getMsg(), HttpMethod.POST, this.lakalaProperties.getHost(), methodName, true, "TSCL", null);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                syncResult = SyncResult.fail(params, null, false, e.getMessage(), HttpMethod.POST, this.lakalaProperties.getHost(), methodName, true, "TSCL", null);
            }
            catch (Throwable throwable) {
                ThirdSysLogUtil.logUpload("TCSL_ACCOUNT_BILL", "\u7ba1\u7406\u8d39\u8d26\u5355\u67e5\u8be2", syncResult, false);
                throw throwable;
            }
            ThirdSysLogUtil.logUpload("TCSL_ACCOUNT_BILL", "\u7ba1\u7406\u8d39\u8d26\u5355\u67e5\u8be2", syncResult, false);
        }
        ThirdSysLogUtil.logUpload("TCSL_ACCOUNT_BILL", "\u7ba1\u7406\u8d39\u8d26\u5355\u67e5\u8be2", syncResult, false);
        return syncResult;
    }

    private String sendRequest(String url, String sig, Map<String, String> headersMap, Map<String, String> paramsMap) throws RuntimeException {
        String requestUrl = url + "&sig=" + sig;
        HttpPost httpPost = new HttpPost(requestUrl);
        CloseableHttpResponse response = null;
        try {
            headersMap.forEach((k, v) -> httpPost.addHeader(k, v));
            CloseableHttpClient httpClient = HttpClients.createDefault();
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Accept", "application/json");
            String requestBody = paramsMap.get("biz");
            httpPost.setEntity((HttpEntity)new StringEntity(requestBody, StandardCharsets.UTF_8));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            httpPost.releaseConnection();
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public String getSig(String appSecret, String baseUrl) {
        try {
            Mac hs256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(appSecret.getBytes("UTF-8"), "HmacSHA256");
            hs256.init(secretKey);
            byte[] bytes = hs256.doFinal(baseUrl.getBytes("UTF-8"));
            return this.toHex(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301HmacSHA256\u7b97\u6cd5", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301utf8\u7f16\u7801", e);
        }
        catch (Exception e) {
            throw new RuntimeException("hs256\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public String toHex(byte[] bytes) {
        StringBuffer hexstr = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() < 2) {
                hexstr.append(0);
            }
            hexstr.append(b);
        }
        return hexstr.toString();
    }

    public String genUrlForGenSig(String host, String methodName, Map<String, String> systemParamsMap, Map<String, String> applicationParamsMap) throws UnsupportedEncodingException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.putAll(systemParamsMap);
        if (applicationParamsMap != null) {
            paramMap.putAll(applicationParamsMap);
        }
        return host + methodName + "?" + this.getSortedParamStr(paramMap);
    }

    public String getSortedParamStr(Map<String, String> params) throws UnsupportedEncodingException {
        TreeSet<String> sortedParams = new TreeSet<String>(params.keySet());
        StringBuilder sortedParamStr = new StringBuilder();
        for (String key : sortedParams) {
            String value = params.get(key);
            if (null == value || "".equals(value) || "sig".equalsIgnoreCase(key) || "biz".equalsIgnoreCase(key)) continue;
            sortedParamStr.append(key + "=" + URLEncoder.encode(value, "UTF-8") + "&");
        }
        return sortedParamStr.substring(0, sortedParamStr.length() - 1);
    }

    public List<BasicNameValuePair> convertToEntity(Map<String, String> applicationParamsMap) throws RuntimeException {
        ArrayList<BasicNameValuePair> formParam = new ArrayList<BasicNameValuePair>();
        try {
            if (applicationParamsMap != null) {
                for (Map.Entry<String, String> entry : applicationParamsMap.entrySet()) {
                    BasicNameValuePair nameValuePair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                    formParam.add(nameValuePair);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("1");
        }
        return formParam;
    }

    public TcslApiClient(LakalaProperties lakalaProperties) {
        this.lakalaProperties = lakalaProperties;
    }
}

