package com.elitesland.fin.application.facade.dto.financial;

import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhiyu.he
 * @date 2025/10/14 14:21
 */
@Data
public class ManagementFeeBillDTO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = -3102074062803538288L;

    @ApiModelProperty("账户号")
    private String accountNo;

    @ApiModelProperty("记账日期 (格式: yyyy-MM-dd HH:mm:ss)")
    private String accountTime;

    @ApiModelProperty("收支类型")
    private String dcType;

    @ApiModelProperty("收支编码")
    private String dcCode;

    @ApiModelProperty("收支名称")
    private String dcName;

    @ApiModelProperty("账户类型")
    private String accountType;

    @ApiModelProperty("平台流水号")
    private String bussNo;

    @ApiModelProperty("云资金流水号")
    private String slBussNo;

    @ApiModelProperty("外部业务单号")
    private String outBussNo;

    @ApiModelProperty("付方档案编码 (三方的门店或公司)")
    private String payArchiveCode;

    @ApiModelProperty("付方档案名称")
    private String payArchiveName;

    @ApiModelProperty("付方银行")
    private String payBank;

    @ApiModelProperty(value = "付款方账户号")
    private String paymentAccountNo;

    @ApiModelProperty(value = "付款方账户名称")
    private String paymentAccountName;

    @ApiModelProperty(value = "收款方账户号")
    private String payeeAccountNo;

    @ApiModelProperty(value = "收款方账户名称")
    private String payeeAccountName;

    @ApiModelProperty("收方档案编码 (三方的门店或公司)")
    private String payeeArchiveCode;

    @ApiModelProperty("收方档案名称")
    private String payeeArchiveName;

    @ApiModelProperty("收方银行")
    private String payeeBank;

    @ApiModelProperty("收支净额")
    private BigDecimal incomeAmount;

    @ApiModelProperty("交易金额")
    private BigDecimal amount;

    @ApiModelProperty("手续费")
    private BigDecimal fee;

    @ApiModelProperty("附言")
    private String postscript;

    @ApiModelProperty("传账状态")
    private String transferStatus;

    @ApiModelProperty("拟定状态")
    private String proposedStatus;
}
