package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_flexible_value")
@org.hibernate.annotations.Table(appliesTo = "fin_flexible_value", comment = "值集明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinFlexibleValueDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "serial_num",columnDefinition = "int(6)  comment '序号'")
    private Integer serialNum;

    @Column(name = "flexible_value_code", columnDefinition = "varchar(20) comment '值'")
    private String flexibleValueCode;

    @Column(name = "flexible_value_name", columnDefinition = "varchar(32) comment '值名称'")
    private String flexibleValueName;

    @Column(name = "descendants_flag", columnDefinition = "tinyint(1) comment '是否有子代'")
    private Boolean descendantsFlag;

    @Column(name = "active_flag", columnDefinition = "tinyint(1) comment '是否启用'")
    private Boolean activeFlag;

    @Column(name = "account_flag", columnDefinition = "tinyint(1) comment '是否记账'")
    private Boolean accountFlag;

    @Column(name = "parent_flexible_value_code", columnDefinition = "varchar(20) comment '上级值'")
    private String parentFlexibleValueCode;

    @Column(name = "parent_flexible_value_name", columnDefinition = "varchar(32) comment '上级值名称'")
    private String parentFlexibleValueName;

    @Column(name = "mas_flexible_value_code", columnDefinition = "varchar(20) comment '主值'")
    private String masFlexibleValueCode;

    @Column(name = "mas_flexible_value_name", columnDefinition = "varchar(32) comment '主值名称'")
    private String masFlexibleValueName;

    @Column(name = "active_start_time", columnDefinition = "datetime(6) comment '起始有效日期'")
    private LocalDateTime activeStartTime;

    @Column(name = "active_end_time", columnDefinition = "datetime(6) comment '终止有效日期'")
    private LocalDateTime activeEndTime;

    @Column(name = "checkitementry", columnDefinition = "longblob comment '核算维度'")
    private String checkitementry;

    @Column(name = "iscash", columnDefinition = "tinyint(1) comment '现金科目'")
    private Boolean iscash;

    @Column(name = "isbank", columnDefinition = "tinyint(1) comment '银行科目'")
    private Boolean isbank;

    @Column(name = "level", columnDefinition = "int(6) comment ''")
    private Integer level;

}
