package com.elitesland.fin.rpc.pur;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.dto.account.PurAccountCheckDtlRpcDTO;
import com.elitesland.pur.dto.account.PurAccountCheckDtlRpcParam;
import com.elitesland.pur.dto.account.PurAccountCheckQtyDTO;
import com.elitesland.pur.dto.account.PurAccountDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.pur.provider.PurAccountCheckDtlProvider;
import com.elitesland.pur.provider.PurAccountProvider;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.elitesland.pur.provider.PurSuppProvider;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/3/8 3:01 下午
 * @version:v1.0
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class RmiPurRpcServiceImpl implements RmiPurRpcService {

    private final PurAccountProvider purAccountProvider;

    private final PurSuppProvider purSuppProvider;
    private final PurAccountCheckDtlProvider purAccountCheckDtlProvider;

    /**
     * 异常检查
     *
     * @param supplier
     * @return
     */
    private Object checkError(Supplier<ApiResult> supplier) {
        try {
            ApiResult apiResult = supplier.get();
            if (!apiResult.isSuccess()) {
                log.error("采购域调用异常:{}", apiResult.getMsg());
                throw new BusinessException(apiResult.getMsg());
            }
            return apiResult.getData();
        } catch (Exception e) {
            log.error("采购域调用异常：", e);
            throw new BusinessException("采购域报错：", e);

        }
    }

    @Override
    public void batchUpdateDocStatus(PurAccountDTO purAccountDTO) {
        this.checkError(() -> purAccountProvider.batchUpdateDocStatus(purAccountDTO));
    }

    @Override
    public void addInvoiceQty(List<PurAccountCheckQtyDTO> param) {
        log.info("调用采购域-回写采购对账单开票数量接口开始，时间：{}，入参：{}", LocalDateTime.now(), JSON.toJSONString(param));
        try {
            ApiResult<Void> apiResult = purAccountProvider.addInvoiceQty(param);
            log.info("调用采购域-回写采购对账单开票数量接口结束，时间：{}，出参：{}", LocalDateTime.now(), JSON.toJSONString(apiResult));
            if (apiResult.isFailed()) {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("purAccountCheckAddInvoiceQty error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用采购域-回写采购对账单开票数量接口失败：" + e);
        }
    }

    @Override
    public List<PurSuppBaseDTO> findBySuppIdBatch(List<Long> ids) {
        log.info("调用采购域-查询供应商信息,参数:{}", ids);
        List<PurSuppBaseDTO> data = purSuppProvider.findBySuppIdBatch(ids).computeData();
        log.info("调用采购域-查询供应商信息,结果:{}", JSONUtil.toJsonStr(data));
        return data;
    }


    /**
     * 查询采购对账明细信息接口
     *
     * @param relateDoc2NoList 关联单编号
     * @return
     */
    @Override
    public List<PurAccountCheckDtlRpcDTO> findPurAccountCheckDtlByParam(List<String> relateDoc2NoList) {
        if (CollectionUtil.isEmpty(relateDoc2NoList)) {
            return Collections.EMPTY_LIST;
        }
        try {
            PurAccountCheckDtlRpcParam purAccountCheckDtlRpcParam = new PurAccountCheckDtlRpcParam();
            purAccountCheckDtlRpcParam.setRelateDoc2NoList(relateDoc2NoList);
            ApiResult<List<PurAccountCheckDtlRpcDTO>> apiResult = purAccountCheckDtlProvider.findSimpleRpcDtoByParam(purAccountCheckDtlRpcParam);
            if (apiResult.isSuccess()) {
                List<PurAccountCheckDtlRpcDTO> rpcDTOList = apiResult.getData();
                if (CollectionUtil.isNotEmpty(rpcDTOList)) {
                    return rpcDTOList;
                }
            } else {
                throw new BusinessException(ApiCode.FAIL, "调用采购域(findPurAccountCheckDtlByParam)查询采购对账明细失败：" + apiResult.getErrorMsg());
            }
        } catch (Exception e) {
            log.error("findPurAccountCheckDtlByParam error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用采购中心dubbo服务异常：" + e);
        }

        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String,PurAccountCheckDtlRpcDTO> findPurAccountCheckDtlMapByCodes(List<String> relateDoc2NoList) {

        List<PurAccountCheckDtlRpcDTO> rpcDTOList = this.findPurAccountCheckDtlByParam(relateDoc2NoList);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<>();
        }
        Map<String, PurAccountCheckDtlRpcDTO> rpcDTOMap = rpcDTOList.stream().collect(Collectors.toMap(PurAccountCheckDtlRpcDTO::getRelateDoc2No, t -> t, (t1, t2) -> t1));

        return rpcDTOMap;

    }

}
