package com.elitesland.fin.utils.tcsl.utils;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.provider.SysThirdApiLogRpcService;
import com.elitesland.fin.utils.tcsl.vo.SyncResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Slf4j
public class ThirdSysLogUtil {

    public static final String APP_CODE = "YST-zxfood";

    private static SysThirdApiLogRpcService sysThirdApiLogRpcService;
//    private static BotSender botSender;

    public static Long logUpload(String businessType, String businessKey, SyncResult uploadResult, Boolean needRetry) {
        ThirdApiLogDTO thirdApiLogDTO = new ThirdApiLogDTO();
        thirdApiLogDTO.setAppCode(APP_CODE);
        thirdApiLogDTO.setBusinessType(businessType);
        thirdApiLogDTO.setBusinessKey(businessKey);
        thirdApiLogDTO.setThirdApp(uploadResult.getThirdApp());
        thirdApiLogDTO.setReqBody(uploadResult.getRequest());
        thirdApiLogDTO.setRespBody(uploadResult.getResp());
        thirdApiLogDTO.setReqHeaders(uploadResult.getReqHeaders());
        thirdApiLogDTO.setReqQueryParams(uploadResult.getReqQueryParams());
        thirdApiLogDTO.setReqMethod(uploadResult.getReqMethod());
        thirdApiLogDTO.setServer(false);
        thirdApiLogDTO.setReqTime(uploadResult.getReqTime());
        thirdApiLogDTO.setUri(uploadResult.getUri());
        thirdApiLogDTO.setServerAddr(uploadResult.getServerAddr());
        thirdApiLogDTO.setRestful(uploadResult.getRestful());
        thirdApiLogDTO.setReqSuccess(uploadResult.getReqSuccess());
        thirdApiLogDTO.setReqFailMsg(uploadResult.getReqFailMsg());
        thirdApiLogDTO.setRespSuccess(uploadResult.getSuccess());
        thirdApiLogDTO.setNeedRetry(needRetry);
        thirdApiLogDTO.setRetryParam(uploadResult.getRetryParamDTO());
        if (sysThirdApiLogRpcService == null) {
            sysThirdApiLogRpcService = SpringUtil.getBean(SysThirdApiLogRpcService.class);
        }
        Long logId = sysThirdApiLogRpcService.saveLog(thirdApiLogDTO).computeData();
        try {
//            if (Boolean.FALSE.equals(thirdApiLogDTO.getRespSuccess())) {
//                if (botSender == null) {
//                    botSender = SpringUtil.getBean(BotSender.class);
//                }
//                BotMessage botMessage = new BotMessage();
//                botMessage.setBusinessKey(businessKey);
//                botMessage.setReqTime(uploadResult.getReqTime());
//                botMessage.setRespTime(LocalDateTime.now());
//                botMessage.setErrorMsg(uploadResult.getReqFailMsg());
//                ZcBotEvent parse = ZcBotEvent.parse(businessType, thirdApiLogDTO.getUri());
//                if (parse == null) {
//                    log.info("未配置告警类型:{}", businessType);
//                    return logId;
//                }
//                botSender.push(() -> ZcBotEvent.of(parse), botMessage);
//            }
        } catch (Exception e) {
            log.error("[BotSender] logUpload ERR: {}", ExceptionUtils.getStackTrace(e));
        }
        return logId;
    }
}
