package com.elitesland.fin.application.facade.vo.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountPeriodLineParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "值集")
public class FinAccountPeriodVO extends BaseModelVO {

    @ApiModelProperty("会计期间编码")
    private String accountPeriodCode;

    @ApiModelProperty("会计期间名称")
    private String accountPeriodName;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("会计期间明细")
    private List<FinAccountPeriodLineVO> detailList;
}
